DELIMITER $$
DROP PROCEDURE IF EXISTS V20210526174746__Create_exam_late_fee_configuration $$
CREATE PROCEDURE V20210526174746__Create_exam_late_fee_configuration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_late_fee_configuration')) THEN 
CREATE TABLE `exam_late_fee_configuration` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `feeStageHeadConfigId` BIGINT NOT NULL,
  `amount` DOUBLE(20,2) NOT NULL,
  `startDate` DATE NOT NULL,
  `endDate` DATE NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdateBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref_fee_stage_head_config_idx` (`feeStageHeadConfigId`),
  KEY `Ref_user_idx` (`lastUpdateBy`),
  CONSTRAINT `fk_elfc_fee_stage_head_config_id`
    FOREIGN KEY (`feeStageHeadConfigId`)
    REFERENCES `fee_stage_head_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_elfc_user_id`
    FOREIGN KEY (`lastUpdateBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210526174746__Create_exam_late_fee_configuration () $$ 
DROP PROCEDURE IF EXISTS V20210526174746__Create_exam_late_fee_configuration $$ 
DELIMITER ;