DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_subjectenrolmentdetails //
CREATE  PROCEDURE sp_tvet_subjectenrolmentdetails(in p_alid varchar(1000))
BEGIN

select distinct
case when char_length(per.nationalId)=13 then per.nationalID else null end as National_Id,
usr1.code as Person_Alternate_Id,
537 as Alternate_Id_Type_Id,
'' as Unit_Standard_Id,
case when stuce.exitDate is not null then 10 else 3 end as Enrolment_Status_Id,
usr.code as Staff_Number,
modo.itemCode as Enrolment_Type_Id,
case when stuce.exitDate is not null then DATE_FORMAT(stuce.exitDate, '%Y%m%d') else DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') end Enrolment_Status_Date,
DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') as Enrolment_Date,
'' as Filler01,
case when aaw.itemCode = 1 then 2 else aaw.itemCode end as Part_Of_Id,
case when aaw.itemCode <> 1 then null 
when aaw.itemCode=1 then prog.programRegistrationId else null end as Qualification_Id,
case when aaw.itemCode='3' then prog.programRegistrationId else null end as Learnership_Id,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
'' as Filler02,
case when aaw.itemCode <> 1 then null when prog.programRegistrationId is not null then null else course.courseCode end as Subject_Code,
case when aaw.itemCode <> 1 then null when prog.programRegistrationId is not null then null else prog.programCode end as Programme_Code,
case when stuce.exitDate is not null then 16 else '' end as Enrolment_Status_Reason_Id,
DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') as Most_Recent_Registration_Date,
case when btc.batchPartTime = 1 then 2 else 1 end as Enrolment_Mode_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
 from
student_course_enrollment stuce
left join prog_batch_period_config progbpc on(progbpc.id=stuce.programBatchPeriodConfigId)
left join batches btc on(btc.id=progbpc.programBatchId and btc.startDate < NOW() and btc.intakeYearId=1)
left join programs prog on(prog.id=btc.programId)
join admission adm on (stuce.admissionId=adm.id and adm.activeStatus=1)
join students stu on(stu.userId=adm.studentId)
join users usr1 on(usr1.id=stu.userid)
join mode_of_delivery modo on(btc.modeOfDeliveryId=modo.id)
join persons per on(per.id=stu.personId)
left join academic_award aaw on(aaw.id=prog.academicAwardId)
left join course_variants cv on(stuce.courseVarientId=cv.id)
left join courses course on(course.id=cv.courseId)
left join program_batch_course_param pbcp on(pbcp.courseVarientId=cv.id) and (pbcp.progBatchPeriodConfigId=progbpc.id)
left join prog_batch_course_faculty pbcf on(pbcf.progBatchCourseParamId=pbcp.id)
left join users usr on(usr.id=pbcf.facultyId)
left join registration_type rt on(prog.registrationTypeId=rt.id)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
left join academy_location al on(al.id=prog.academyLocationId)
left join locations loc on(loc.id=al.locationId)
where year(now()) between year(btc.startDate) and year(btc.tillDate) and usr1.status=1
 and FIND_IN_SET( al.id,p_alid)
group by usr1.code, course.courseCode;

END//
DELIMITER ;