DELIMITER $$
DROP PROCEDURE IF EXISTS V20210601104041__Create_VGU_Views $$
CREATE PROCEDURE V20210601104041__Create_VGU_Views()
BEGIN
SET SQL_SAFE_UPDATES=0;
/** view 1- academicterm_details Start */
DROP VIEW IF EXISTS academicterm_details;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='academicterm_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `academicterm_details` AS
    SELECT DISTINCT
        `at`.`itemCode` AS `itemCode`,
        `at`.`itemValue` AS `itemValue`,
        (CASE
            WHEN (`at`.`whetherCurrentAcademicTerm` = '0') THEN 'False'
            WHEN (`at`.`whetherCurrentAcademicTerm` = '1') THEN 'True'
            ELSE NULL
        END) AS `whetherCurrentAcademicTerm`
    FROM
        `academic_term` `at`;
END IF;
/** view 1- academicterm_details End */

/** view 2- academicyear_details start */
DROP VIEW IF EXISTS academicyear_details;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='academicyear_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `academicyear_details` AS
    SELECT DISTINCT
        `ay`.`yearName` AS `yearName`,
        `ayt`.`tenureName` AS `tenureName`,
        `ayt`.`startDate` AS `startDate`,
        `ayt`.`tillDate` AS `tillDate`
    FROM
        (`academy_year` `ay`
        LEFT JOIN `academy_year_tenure` `ayt` ON ((`ay`.`id` = `ayt`.`academyYearId`)));
END IF;
/** view 2- academicyear_details End */

/** view 3- applicant_score start */
DROP VIEW IF EXISTS applicant_score;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='applicant_score')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `applicant_score` AS
    SELECT DISTINCT
        `appl`.`code` AS `Application_ID`,
        (CASE
            WHEN (`psps`.`batchSlot` = 1) THEN 'May'
            WHEN (`psps`.`batchSlot` = 2) THEN 'July'
            ELSE NULL
        END) AS `Admission_Method`,
        `ep`.`itemValue` AS `Exam_Passed`,
        `sub`.`itemCode` AS `Subject`,
        `asmi`.`marks` AS `Subject_Score`,
        `ebm`.`itemValue` AS `Admission_Block`
    FROM
        (((((((((`applicant_education_histories` `aeh`
        JOIN `application` `appl` ON ((`aeh`.`applicantPersonId` = `appl`.`id`)))
        LEFT JOIN `exam_passed` `ep` ON ((`ep`.`id` = `aeh`.`examPassedId`)))
        LEFT JOIN `applicant_education_histories_cd` `aehcd` ON ((`aehcd`.`applicantEducationHistoryId` = `aeh`.`id`)))
        JOIN `application_program` `ap` ON ((`ap`.`applicationId` = `appl`.`id`)))
        JOIN `program_selection_process` `psp` ON ((`psp`.`programBatchSeatConfigId` = `ap`.`progBatchSeatConfigId`)))
        JOIN `program_slctn_process_stages` `psps` ON ((`psps`.`programSelectionProcessId` = `psp`.`id`)))
        LEFT JOIN `exam_board_master` `ebm` ON ((`ebm`.`id` = `aeh`.`examBoardId`)))
        LEFT JOIN `applicant_subject_mark_info` `asmi` ON ((`asmi`.`applicantEducationHistoryId` = `aeh`.`id`)))
        LEFT JOIN `subjects` `sub` ON ((`sub`.`id` = `asmi`.`subjectId`)))
    WHERE
        (`ep`.`itemValue` = 'NHE');
END IF;
/** view 3- applicant_score End */


/** view 4- applicant_englishTest_score start */
DROP VIEW IF EXISTS applicant_englishTest_score;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='applicant_englishTest_score')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `applicant_englishTest_score` AS
    SELECT DISTINCT
        `appl`.`code` AS `Application_ID`,
        `ep`.`itemValue` AS `English_Test_Name`,
        `aeh`.`marksOrGradeObtained` AS `English_Test_Score`,
        (CASE
            WHEN (`psps`.`batchSlot` = 1) THEN 'May'
            WHEN (`psps`.`batchSlot` = 2) THEN 'July'
            ELSE NULL
        END) AS `Admission_Method`
    FROM
        ((((((`applicant_education_histories` `aeh`
        JOIN `applicant_person` `app` ON ((`aeh`.`applicantPersonId` = `app`.`id`)))
        JOIN `application` `appl` ON ((`appl`.`applicantPersonId` = `app`.`id`)))
        JOIN `exam_passed` `ep` ON ((`ep`.`id` = `aeh`.`examPassedId`)))
        JOIN `application_program` `ap` ON ((`ap`.`applicationId` = `appl`.`id`)))
        JOIN `program_selection_process` `psp` ON ((`psp`.`programBatchSeatConfigId` = `ap`.`progBatchSeatConfigId`)))
        JOIN `program_slctn_process_stages` `psps` ON ((`psps`.`programSelectionProcessId` = `psp`.`id`)))
    WHERE
        (`ep`.`itemValue` IN ('TOEFL' , 'ONSET', 'IELTS'));
END IF;
/** view 4- applicant_englishTest_score End */

/** view 5- course_view start */
DROP VIEW IF EXISTS course_view; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='course_view')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `course_view` AS
    SELECT 
        `cou`.`courseName` AS `Name`,
        `cou`.`courseCode` AS `Code`,
        `dept`.`deptName` AS `DepartmentName`,
        `dept`.`shortCode` AS `DepartmentCode`,
        `cou`.`courseCredits` AS `Credit`,
        `cou`.`courseCode` AS `Code_to_printed`,
        `cou`.`nameToBePrinted` AS `nameToBePrinted`
    FROM
        (`courses` `cou`
        JOIN `department` `dept` ON ((`dept`.`id` = `cou`.`departmentId`)));
END IF;
/** view 5- course_view End */

/** view 6- application_list_view start */
DROP VIEW IF EXISTS application_list_view;
 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='application_list_view')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `application_list_view` AS
    SELECT 
        `t3`.`code` AS `APPLICATION_ID`,
        `t2`.`printName` AS `FULL_NAME`,
        `t2`.`firstName` AS `FIRST_NAME`,
        `t2`.`middleName` AS `MIDDLE_NAME`,
        `t2`.`lastName` AS `LAST_NAME`,
        `t20`.`academyName` AS `ACADEMY`,
        `t4`.`displayName` AS `ACADEMY_DISPLAY_NAME`,
        `t4`.`academyCode` AS `ACADEMY_CODE`,
        `t19`.`locationName` AS `LOCATION`,
        `t5`.`programName` AS `PROGRAM_NAME`,
        `t5`.`programNameToBePrint` AS `PROGRAM_NAME_PRINTED`,
        `t5`.`programShortName` AS `PROGRAM_SHORT_NAME`,
        `pg`.`groupName` AS `PROGRAM_GROUP_NAME`,
        `t15`.`batchName` AS `BATCH`,
        `t8`.`seatName` AS `SEAT_TYPE`,
        `t52`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `t3`.`currentStatus` AS `APPLICATION_VIEW_STATUS`,
        `t51`.`value` AS `PROGRAM_WITHDRAWN_REASON`,
        `t1`.`currentStatus` AS `PROGRAM_VIEW_STATUS`,
        `t12`.`stageName` AS `CURRENT_STAGE`,
        `t1`.`offerLetterAcceptanceDate` AS `OFFER_LETTER_ACCEPTANCE_DATE`,
        `t9`.`currentStatus` AS `STAGE_VIEW_STATUS`,
        `t18`.`status` AS `ADMISSION_VIEW_STATUS`,
        `t3`.`applicationCreationSource` AS `APPLICATION_CREATION_SOURCE`,
        `t50`.`printName` AS `APPROVED_PERSON`,
        `t3`.`applicationApprovedOn` AS `APPLICATION_APPROVED_DATE`,
        `t3`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `t43`.`firstName` AS `FATHERS_FULL_NAME`,
        `t43`.`firstName` AS `FATHERS_FIRST_NAME`,
        `t43`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `t43`.`lastName` AS `FATHERS_LAST_NAME`,
        `t48`.`firstName` AS `MOTHERS_FULL_NAME`,
        `t48`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `t48`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `t48`.`lastName` AS `MOTHERS_LAST_NAME`,
        `t27`.`beneficiaryName` AS `BENEFICIARY_NAME`,
        `t27`.`accountNumber` AS `ACCOUNT_NUMBER`,
        `t27`.`accountType` AS `ACCOUNT_TYPE`,
        `t27`.`bankName` AS `BANK_NAME`,
        `t27`.`branchName` AS `BRANCH_NAME`,
        `t27`.`IFSCode` AS `IFSCODE`,
        `t2`.`birthDate` AS `DATE_OF_BIRTH`,
        `gen`.`itemValue` AS `GENDER`,
        `t2`.`category` AS `CATEGORY`,
        `t2`.`emailId` AS `EMAIL`,
        `t2`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `t2`.`mobileNumber` AS `MOBILE_NUMBER`,
        `t2`.`phoneCountryCode` AS `PHONE_COUNTRY_CODE`,
        `t2`.`phoneAreaCode` AS `PHONE_AREA_CODE`,
        `t2`.`phoneNo` AS `PHONE_NO`,
        `t2`.`bloodGroup` AS `BLOOD_GROUP`,
        `t45`.`itemValue` AS `RELIGION`,
        `t46`.`itemValue` AS `CASTE_CATEGORY`,
        `t2`.`comments` AS `APPLICATION_GRID_COMMENTS`,
        `t10`.`whetherFeePlanApplicable` AS `WHETHER_FEE_PLAN_APPLICABLE`,
        `t44`.`billStatus` AS `BILL_STATUS`,
        `t3`.`currentStatus` AS `APPLICATION_STATUS`,
        `t1`.`currentStatus` AS `PROGRAM_STATUS`,
        `t9`.`currentStatus` AS `STAGE_STATUS`,
        `t14`.`status` AS `ADMISSION_STATUS`,
        `t49`.`itemValue` AS `NATIONALITY`,
        `t2`.`nationalID` AS `NATIONAL_ID`,
        `t2`.`printName` AS `APPLICATION_PERSON_PRINTNAME`,
        `t2`.`id` AS `APPLICATION_PERSON_ID`,
        `t14`.`id` AS `ADMISSION_PRIMERY_ID`,
        `t3`.`id` AS `APPLICATION_PRIMERY_ID`,
        `t1`.`id` AS `APPLICATION_PROGRAM_ID`,
        `t7`.`id` AS `PROG_BATCH_SEAT_CONFIG_ID`,
        `t1`.`academyLocationId` AS `ACADEMY_LOCATION_ID`,
        `t3`.`id` AS `ID`,
        `t26`.`externalUserId` AS `EXTERNAL_USER_ID`,
        `t7`.`id` AS `IS_OFFER_LETTER_APPLICABLE`,
        `country`.`countryName` AS `COUNTRY_NAME`,
        `cr`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `city`.`cityName` AS `CITY_NAME`,
        `t89`.`itemCode` AS `intake_year`,
        `t89`.`id` AS `intakeYearId`,
        `address`.`id` AS `address_id`,
        `modod`.`itemValue` AS `Mode_of_Delivery`,
        (CASE
            WHEN (`t15`.`batchPartTime` = 1) THEN 'Part Time'
            WHEN (`t15`.`batchPartTime` = 0) THEN 'Full Time'
            ELSE NULL
        END) AS `Registration_Type`,
        `sp`.`name` AS `Selection_Process`,
        `apc`.`cf1` AS `High_School`,
        `apc`.`cf2` AS `High_School_Province`,
        (CASE
            WHEN (`t10`.`batchSlot` = 1) THEN 'May'
            WHEN (`t10`.`batchSlot` = 2) THEN 'July'
            ELSE NULL
        END) AS `Admission_Method`,
        `t1`.`currentStatus` AS `Offer_Status`,
        `usr`.`code` AS `Student_ID`,
        `t14`.`admissionDate` AS `admissionDate`
    FROM
        ((((((((((((((((((((((((((((((((((((((((`application` `t3`
        LEFT JOIN `external_user_association` `t26` ON (((`t3`.`id` = `t26`.`applicationId`)
            AND (`t26`.`referencyEntityType` = 'APPLICATION'))))
        JOIN `applicant_person` `t2` ON ((`t2`.`id` = `t3`.`applicantPersonId`)))
        LEFT JOIN `gender` `gen` ON ((`gen`.`id` = `t2`.`genderId`)))
        LEFT JOIN `applicant_address` `address` ON (((`address`.`applicantPersonId` = `t2`.`id`)
            AND (`address`.`whetherPrimary` = 1))))
        LEFT JOIN `country` ON ((`country`.`id` = `address`.`countryId`)))
        LEFT JOIN `country_region` `cr` ON ((`cr`.`id` = `address`.`parentRegionId`)))
        LEFT JOIN `city` ON ((`city`.`id` = `address`.`cityId`)))
        LEFT JOIN `application_program` `t1` ON ((`t3`.`id` = `t1`.`applicationId`)))
        LEFT JOIN `users` `t50` ON ((`t50`.`id` = `t3`.`applicationApprovedBy`)))
        LEFT JOIN `applicant_bank_details` `t27` ON ((`t2`.`bankDetailId` = `t27`.`id`)))
        LEFT JOIN `applicant_hostel_requirement` `t52` ON (((`t52`.`applicantPersonId` = `t2`.`id`)
            AND (`t52`.`whetherDeleted` = 0))))
        LEFT JOIN `nationalities` `t49` ON ((`t2`.`nationalityId` = `t49`.`id`)))
        LEFT JOIN `caste_categories` `t46` ON ((`t2`.`casteCategoryId` = `t46`.`id`)))
        LEFT JOIN `applicant_person_relationships` `t42` ON (((`t42`.`applicantPersonId` = `t2`.`id`)
            AND (`t42`.`relationship` = 'FATHER')
            AND (`t42`.`whetherDeleted` = 0))))
        LEFT JOIN `religions` `t45` ON ((`t2`.`religionId` = `t45`.`id`)))
        LEFT JOIN `applicant_person_relationships` `t47` ON (((`t47`.`applicantPersonId` = `t2`.`id`)
            AND (`t47`.`relationship` = 'MOTHER')
            AND (`t47`.`whetherDeleted` = 0))))
        LEFT JOIN `application_admission_detail` `t18` ON ((`t18`.`applicationProgramId` = `t1`.`id`)))
        LEFT JOIN `programs` `t5` ON ((`t5`.`id` = `t1`.`programId`)))
        LEFT JOIN `program_group` `pg` ON ((`t5`.`programGroupId` = `pg`.`id`)))
        LEFT JOIN `academy_location` `t4` ON ((`t4`.`id` = `t1`.`academyLocationId`)))
        LEFT JOIN `prog_batch_seat_config` `t7` ON ((`t7`.`id` = `t1`.`progBatchSeatConfigId`)))
        LEFT JOIN `program_slctn_process_stages` `t10` ON ((`t10`.`id` = `t1`.`currentStageId`)))
        LEFT JOIN `application_prog_withdraw_reasons` `t51` ON ((`t51`.`id` = `t1`.`withdrawl_reason_id`)))
        LEFT JOIN `applicant_person` `t43` ON (((`t43`.`id` = `t42`.`relatedApplicantPersonId`)
            AND (`t42`.`relationship` = 'FATHER')
            AND (`t42`.`whetherDeleted` = 0))))
        LEFT JOIN `applicant_person` `t48` ON (((`t48`.`id` = `t47`.`relatedApplicantPersonId`)
            AND (`t47`.`relationship` = 'MOTHER')
            AND (`t47`.`whetherDeleted` = 0))))
        LEFT JOIN `admission` `t14` ON ((`t14`.`applicationAdmissionId` = `t18`.`id`)))
        LEFT JOIN `users` `usr` ON ((`usr`.`id` = `t14`.`studentId`)))
        LEFT JOIN `locations` `t19` ON ((`t19`.`id` = `t4`.`locationId`)))
        LEFT JOIN `academies` `t20` ON ((`t20`.`id` = `t4`.`academyId`)))
        LEFT JOIN `seat_types` `t8` ON ((`t8`.`id` = `t7`.`seatTypeId`)))
        LEFT JOIN `batches` `t15` ON ((`t15`.`id` = `t7`.`programBatchId`)))
        LEFT JOIN `intake_year` `t89` ON ((`t89`.`id` = `t15`.`intakeYearId`)))
        LEFT JOIN `application_prog_stage` `t9` ON (((`t9`.`applicationProgramId` = `t1`.`id`)
            AND (`t9`.`programSelectionProcessStageId` = `t10`.`id`))))
        LEFT JOIN `slctn_process_stage` `t11` ON ((`t11`.`id` = `t10`.`selectionProcessStageId`)))
        LEFT JOIN `bill_header` `t44` ON ((`t44`.`applicationProgramStageId` = `t9`.`id`)))
        LEFT JOIN `selection_stage` `t12` ON ((`t12`.`id` = `t11`.`stageId`)))
        LEFT JOIN `mode_of_delivery` `modod` ON ((`modod`.`id` = `t15`.`modeOfDeliveryId`)))
        LEFT JOIN `program_selection_process` `psp` ON ((`psp`.`id` = `t10`.`programSelectionProcessId`)))
        LEFT JOIN `slctn_process` `sp` ON ((`sp`.`id` = `psp`.`selectionProcessId`)))
        LEFT JOIN `applicant_person_cd` `apc` ON ((`apc`.`applicantPersonId` = `t2`.`id`)))
    WHERE
        ((`t3`.`currentStatus` <> 'SOLD')
            AND (`t3`.`currentStatus` NOT IN ('DIRECT_SUBMISSION_TOKEN_GENERATED' , 'FORM_SALE_TOKEN_GENERATED'))
            AND (`t3`.`code` IS NOT NULL))
    ORDER BY `t3`.`applicationCreatedOn` DESC;
END IF;
/** view 6- application_list_view End */

/** view 7- event_details start */

DROP VIEW IF EXISTS event_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='event_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `event_details` AS
    SELECT DISTINCT
        `rb`.`id` AS `Event_ID`,
        `rb`.`eventName` AS `Event_Name`,
        `rb`.`eventDate` AS `eventDate`,
        `bp`.`value` AS `Event_purpose`,
        `rb`.`venue` AS `venue`,
        `rb`.`purpose` AS `Purpose_Detail`,
        `rb`.`eventDesc` AS `Event_Description`,
        `rb`.`bookedBy` AS `bookedBy`
    FROM
        (`resource_bookings` `rb`
        JOIN `booking_purposes` `bp` ON ((`bp`.`id` = `rb`.`bookingPurposeId`)));
END IF;
/** view 7- event_details End */

/** view -8 faculty_details start */
DROP VIEW IF EXISTS faculty_details;
 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='faculty_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `faculty_details` AS
    SELECT DISTINCT
        `al`.`academyCode` AS `Faculty_Code`,
        `aca`.`academyName` AS `Faculty_Name`,
        `aca`.`startDate` AS `startDate`,
        `aca`.`tillDate` AS `tillDate`,
        `aca`.`status` AS `status`
    FROM
        (`academies` `aca`
        JOIN `academy_location` `al` ON ((`al`.`academyId` = `aca`.`id`)));
END IF;
/** view 8- faculty_details End */

/** view -9 graduation_list start */
DROP VIEW IF EXISTS graduation_list; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='graduation_list')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `graduation_list` AS
    SELECT DISTINCT
        `usr`.`code` AS `Student_ID`,
        `usr`.`printName` AS `Print_Name`,
        `prog`.`programName` AS `Study_Program`,
        `btc`.`batchName` AS `Intake`,
        `btc`.`tillDate` AS `Graduate_date`,
        `epr`.`CGPA` AS `CGPA`,
        (SELECT 
                COUNT(DISTINCT `a`.`id`) AS `Total_number_of_semester`
            FROM
                ((`prog_batch_period_config` `a`
                JOIN `batches` `b` ON ((`a`.`programBatchId` = `b`.`id`)))
                JOIN `programs` `c` ON ((`b`.`programId` = `c`.`id`)))
            WHERE
                (`c`.`id` = `prog`.`id`)
            GROUP BY `c`.`id`) AS `Total_number_of_semester`
    FROM
        ((((`evaluation_program_rank` `epr`
        JOIN `batches` `btc` ON ((`btc`.`id` = `epr`.`batchId`)))
        JOIN `programs` `prog` ON ((`prog`.`id` = `btc`.`programId`)))
        JOIN `admission` `adm` ON ((`adm`.`id` = `epr`.`admissionId`)))
        JOIN `users` `usr` ON ((`usr`.`id` = `adm`.`studentId`)));
END IF;
/** view 9- graduation_list End */

/** view -10 lecturer_workload start */
DROP VIEW IF EXISTS lecturer_workload;  

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='lecturer_workload')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `lecturer_workload` AS
    SELECT DISTINCT
        `at`.`itemValue` AS `academicterm`,
        `usr`.`code` AS `Lecturer_ID`,
        `usr`.`printName` AS `Lecturer_Name`,
        `cour`.`courseCode` AS `ModuleCode`,
        `cour`.`courseName` AS `Module`,
        (SELECT 
                COUNT(`ccv`.`sessionNumber`)
            FROM
                `course_coverage_plan` `ccv`
            WHERE
                ((`ccv`.`courseId` = `cour`.`id`)
                    AND (`ccv`.`facultyId` = `usr`.`id`))
            GROUP BY `ccv`.`courseId`) AS `No_of_Sessions`,
        (SELECT 
                (SUM(TIMESTAMPDIFF(MINUTE,
                        `ccv`.`slotFrom`,
                        `ccv`.`slotTo`)) / 60) AS `Hours`
            FROM
                `course_coverage_plan` `ccv`
            WHERE
                ((`ccv`.`courseId` = `cour`.`id`)
                    AND (`ccv`.`facultyId` = `usr`.`id`))
            GROUP BY `ccv`.`courseId`) AS `Hours`
    FROM
        ((((((((`program_batch_course_param` `pbcp`
        JOIN `batches` `btc` ON ((`btc`.`id` = `pbcp`.`programBatchId`)))
        JOIN `programs` `prog` ON ((`prog`.`id` = `btc`.`programId`)))
        JOIN `academy_location` `al` ON ((`al`.`id` = `prog`.`academyLocationId`)))
        JOIN `prog_batch_period_config` `pbpc` ON ((`pbpc`.`id` = `pbcp`.`progBatchPeriodConfigId`)))
        JOIN `prog_batch_course_faculty` `pbcf` ON ((`pbcf`.`progBatchCourseParamId` = `pbcp`.`id`)))
        JOIN `users` `usr` ON ((`usr`.`id` = `pbcf`.`facultyId`)))
        JOIN `courses` `cour` ON ((`cour`.`id` = `pbcp`.`courseId`)))
        JOIN `academic_term` `at` ON ((`at`.`id` = `pbpc`.`academicTermId`)));
END IF;
/** view 10- lecturer_workload End */

/** view -11 moduleparameters_details start */
DROP VIEW IF EXISTS moduleparameters_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='moduleparameters_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `moduleparameters_details` AS
    SELECT DISTINCT
        `prog`.`programCode` AS `Study_Program_Code`,
        `btc`.`batchName` AS `Intake`,
        `pbpc`.`programPeriodName` AS `Semesters`,
        `cour`.`courseCode` AS `Module_Code`,
        `cour`.`courseName` AS `Module_Name`,
        `stf`.`code` AS `Lecturer_Code`,
        `stf`.`printName` AS `Lecturer_Name`
    FROM
        ((((((`program_batch_course_param` `pbcp`
        JOIN `batches` `btc` ON ((`btc`.`id` = `pbcp`.`programBatchId`)))
        JOIN `programs` `prog` ON ((`prog`.`id` = `btc`.`programId`)))
        JOIN `prog_batch_period_config` `pbpc` ON ((`pbpc`.`id` = `pbcp`.`progBatchPeriodConfigId`)))
        JOIN `courses` `cour` ON ((`cour`.`id` = `pbcp`.`courseId`)))
        JOIN `prog_batch_course_faculty` `pbcf` ON ((`pbcf`.`progBatchCourseParamId` = `pbcp`.`id`)))
        JOIN `users` `stf` ON ((`pbcf`.`facultyId` = `stf`.`id`)));
END IF;
/** view 11- moduleparameters_details End */

/** view -12 module_grade_details start */
DROP VIEW IF EXISTS module_grade_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='module_grade_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `module_grade_details` AS
    SELECT 
        `prog`.`programName` AS `Study_Program_Name`,
        `btc`.`batchName` AS `Intake`,
        `pbpc`.`printName` AS `Semester`,
        `ate`.`itemValue` AS `Academic_Term`,
        `cour`.`courseCode` AS `Module_Code`,
        SUM((CASE
            WHEN (`epr`.`status` = 'PASS') THEN 1
            ELSE 0
        END)) AS `Number_of_Students_Passed`,
        SUM((CASE
            WHEN (`epr`.`status` = 'FAIL') THEN 1
            ELSE 0
        END)) AS `Number_of_Students_Failed`
    FROM
        (((((((`evaluation_plan_rank` `epr`
        JOIN `prog_batch_period_config` `pbpc` ON ((`epr`.`periodId` = `pbpc`.`id`)))
        JOIN `batches` `btc` ON ((`btc`.`id` = `pbpc`.`programBatchId`)))
        JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `academic_term` `ate` ON ((`pbpc`.`academicTermId` = `ate`.`id`)))
        LEFT JOIN `course_variants` `cv` ON ((`epr`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `courses` `cour` ON ((`cour`.`id` = `cv`.`courseId`)))
        JOIN `admission` `adm` ON ((`adm`.`id` = `epr`.`admissionId`)))
    GROUP BY `cour`.`id` , `prog`.`id`;
END IF;
/** view 12- module_grade_details End */

/** view -13 program_intake_details start */
DROP VIEW IF EXISTS program_intake_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='program_intake_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `program_intake_details` AS
    SELECT DISTINCT
        `prog`.`programCode` AS `Study_Program_Code`,
        `btc`.`batchName` AS `Intake`,
        `ir`.`itemValue` AS `Intake_Year`,
        `btc`.`seatCapacity` AS `seatCapacity`,
        `btc`.`startDate` AS `startDate`,
        `btc`.`tillDate` AS `tillDate`
    FROM
        ((`batches` `btc`
        JOIN `programs` `prog` ON ((`prog`.`id` = `btc`.`programId`)))
        JOIN `intake_year` `ir` ON ((`ir`.`id` = `btc`.`intakeYearId`)));
END IF;
/** view 13- program_intake_details End */

/** view -14 program_intake_semester_details start */
DROP VIEW IF EXISTS program_intake_semester_details; 
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='program_intake_semester_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `program_intake_semester_details` AS
    SELECT DISTINCT
        `prog`.`programCode` AS `Study_Program_Code`,
        `btc`.`batchName` AS `Intake`,
        `pbpc`.`programPeriodSeq` AS `Study_Program_Semester_Sequence`,
        `pbpc`.`programPeriodName` AS `Study_Program_Semester_Name`,
        `pbpc`.`printName` AS `printName`,
        `at`.`itemValue` AS `Academic_Term`,
        `pbpc`.`programPeriodStart` AS `Semester_Start_Date`,
        `pbpc`.`programPeriodEnd` AS `Semester_End_Date`
    FROM
        (((`prog_batch_period_config` `pbpc`
        JOIN `batches` `btc` ON ((`btc`.`id` = `pbpc`.`programBatchId`)))
        JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `academic_term` `at` ON ((`at`.`id` = `pbpc`.`academicTermId`)));
END IF;
/** view 14- program_intake_semester_details End */

/** view -15 scholarship_awardee_details start */
DROP VIEW IF EXISTS scholarship_awardee_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='scholarship_awardee_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `scholarship_awardee_details` AS
    SELECT DISTINCT
        `usr`.`code` AS `Student_ID`,
        `usr`.`printName` AS `student_name`,
        `prog`.`programName` AS `program`,
        `btc`.`batchName` AS `Intake`,
        `pbpc`.`printName` AS `Semester`,
        `sch`.`scholarshipName` AS `scholarshipname`,
        `schawd`.`awardedOn` AS `Award_Date`,
        `schawd`.`appliedOn` AS `Applied_Date`,
        `schawd`.`validFrom` AS `validFrom`,
        `schawd`.`validUpto` AS `Valid_Till`
    FROM
        (((((`scholarship_awardees` `schawd`
        JOIN `users` `usr` ON ((`usr`.`id` = `schawd`.`studentId`)))
        JOIN `programs` `prog` ON ((`schawd`.`programId` = `prog`.`id`)))
        JOIN `batches` `btc` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `prog_batch_period_config` `pbpc` ON ((`pbpc`.`programBatchId` = `btc`.`id`)))
        JOIN `scholarship` `sch` ON ((`sch`.`id` = `schawd`.`scholarshipId`)))
    GROUP BY `schawd`.`id`;
END IF;
/** view 15- scholarship_awardee_details End */

/** view -16 scholarship_master_details start */
DROP VIEW IF EXISTS scholarship_master_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='scholarship_master_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `scholarship_master_details` AS
    SELECT DISTINCT
        `sch`.`scholarshipCode` AS `Scholarship_ID`,
        `sch`.`scholarshipName` AS `scholarshipname`,
        `sch`.`scholarshipType` AS `scholarshiptype`,
        `schor`.`organizationName` AS `organizationName`,
        `sch`.`validityInMonth` AS `validity`
    FROM
        (`scholarship` `sch`
        LEFT JOIN `scholarship_organizations` `schor` ON ((`sch`.`scholarshipOrganizationId` = `schor`.`id`)));
END IF;
/** view 16- scholarship_master_details End */


/** view -17 selectionprocess_details start */
DROP VIEW IF EXISTS selectionprocess_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='selectionprocess_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `selectionprocess_details` AS
    SELECT DISTINCT
        `pro`.`name` AS `Selection_Process_Name`,
        `pro`.`status` AS `status`,
        `pro`.`selectionProcessType` AS `selectionprocesstype`,
        `ss`.`stageName` AS `stagename`,
        `prostag`.`stageOrder` AS `stageOrder`
    FROM
        ((`slctn_process` `pro`
        LEFT JOIN `slctn_process_stage` `prostag` ON ((`prostag`.`selectionProcessId` = `pro`.`id`)))
        LEFT JOIN `selection_stage` `ss` ON ((`ss`.`id` = `prostag`.`stageId`)));
END IF;
/** view 17- selectionprocess_details End */

/** view -18 selection_stage_marks_details start */
DROP VIEW IF EXISTS selection_stage_marks_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='selection_stage_marks_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `selection_stage_marks_details` AS
    SELECT 
        `appl`.`code` AS `Application_ID`,
        `aper`.`printName` AS `Applicant_Name`,
        `ss`.`stageName` AS `stagename`,
        `aps`.`currentStatus` AS `currentStatus`,
        `aps`.`stageMarks` AS `Stage_Marks`,
        `aps`.`effectiveStageMarkWithWeightage` AS `Effective_Marks`
    FROM
        ((((((`application_prog_stage` `aps`
        JOIN `application_program` `ap` ON ((`aps`.`applicationProgramId` = `ap`.`id`)))
        JOIN `application` `appl` ON ((`appl`.`id` = `ap`.`applicationId`)))
        JOIN `applicant_person` `aper` ON ((`aper`.`id` = `appl`.`applicantPersonId`)))
        JOIN `program_slctn_process_stages` `psps` ON ((`psps`.`id` = `aps`.`programSelectionProcessStageId`)))
        JOIN `slctn_process_stage` `sps` ON ((`psps`.`selectionProcessStageId` = `sps`.`id`)))
        JOIN `selection_stage` `ss` ON ((`ss`.`id` = `sps`.`stageId`)));
END IF;
/** view 18- selection_stage_marks_details End */

/** view -19 student_dropout_list start */
DROP VIEW IF EXISTS student_dropout_list; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='student_dropout_list')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `student_dropout_list` AS
    SELECT 
        `usr`.`code` AS `Student_ID`,
        `usr`.`printName` AS `printname`,
        `pgm`.`programCode` AS `Study_Program`,
        `b`.`batchName` AS `Intake`,
        `usr`.`lockedOn` AS `Effective_date`
    FROM
        ((((`program_batch_students` `pbs`
        JOIN `admission` `adm` ON ((`adm`.`id` = `pbs`.`admissionId`)))
        JOIN `users` `usr` ON ((`adm`.`studentId` = `usr`.`id`)))
        JOIN `batches` `b` ON ((`b`.`id` = `pbs`.`programBatchId`)))
        JOIN `programs` `pgm` ON ((`b`.`programId` = `pgm`.`id`)))
    WHERE
        (`usr`.`status` = '0')
    GROUP BY `usr`.`id`;
END IF;
/** view 19- student_dropout_list End */


/** view -20 student_grade_modulewise start */
DROP VIEW IF EXISTS student_grade_modulewise;  

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='student_grade_modulewise')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `student_grade_modulewise` AS
    SELECT DISTINCT
        `prog`.`programCode` AS `Study_Program_Code`,
        `prog`.`programName` AS `Study_Program_Name`,
        `btc`.`batchName` AS `Intake`,
        `pbpc`.`printName` AS `Semester`,
        `ate`.`itemValue` AS `Academic_Term`,
        `cour`.`courseCode` AS `Module_Code`,
        `cour`.`courseName` AS `Module_Name`,
        `adm`.`code` AS `Student_ID`,
        `epr`.`grade` AS `grade`,
        `epr`.`status` AS `Pass_Fail`,
        COUNT((CASE
            WHEN (`amt`.`itemValue` = 'Present') THEN 1
            ELSE NULL
        END)) AS `Present`,
        COUNT((CASE
            WHEN (`amt`.`itemValue` = 'Absent') THEN 1
            ELSE NULL
        END)) AS `Absent`,
        `asd`.`Total_Attempts_to_pass` AS `Total_Attempts_to_pass`
    FROM
        ((((((((((`evaluation_plan_rank` `epr`
        JOIN `prog_batch_period_config` `pbpc` ON ((`epr`.`periodId` = `pbpc`.`id`)))
        JOIN `batches` `btc` ON ((`btc`.`id` = `pbpc`.`programBatchId`)))
        JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `academic_term` `ate` ON ((`pbpc`.`academicTermId` = `ate`.`id`)))
        LEFT JOIN `course_variants` `cv` ON ((`epr`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `courses` `cour` ON ((`cour`.`id` = `cv`.`courseId`)))
        JOIN `admission` `adm` ON ((`adm`.`id` = `epr`.`admissionId`)))
        LEFT JOIN `student_course_attendance_details` `stucad` ON ((`adm`.`id` = `stucad`.`admissionId`)))
        LEFT JOIN `attendance_marking_type` `amt` ON ((`stucad`.`attendanceMarkingTypeId` = `amt`.`id`)))
        LEFT JOIN (SELECT 
            COUNT(`epr1`.`id`) AS `Total_Attempts_to_pass`,
                `epr1`.`id` AS `epr1id`
        FROM
            (((`evaluation_plan_rank` `epr1`
        LEFT JOIN `course_variants` `cv1` ON ((`epr1`.`courseVariantId` = `cv1`.`id`)))
        LEFT JOIN `courses` `cour1` ON ((`cour1`.`id` = `cv1`.`courseId`)))
        JOIN `admission` `adm1` ON ((`adm1`.`id` = `epr1`.`admissionId`)))
        GROUP BY `adm1`.`id` , `cour1`.`id`) `asd` ON ((`asd`.`epr1id` = `epr`.`id`)))
    GROUP BY `adm`.`id`;
END IF;
/** view 20- student_grade_modulewise End */

/** view -21 student_list_view start */
DROP VIEW IF EXISTS student_list_view;  

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='student_list_view')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `student_list_view` AS
    SELECT 
        `T1`.`userId` AS `ID`,
        `T6`.`photoUrl` AS `PERSON_IMAGE`,
        `T1`.`personId` AS `PERSON_ID`,
        `T1`.`userId` AS `APPLICATION_ID`,
        `T3`.`code` AS `ADMISSION_NUMBER`,
        `T2`.`code` AS `STUDENT_ID`,
        `T6`.`printName` AS `STUDENT_NAME`,
        `T6`.`firstName` AS `FIRST_NAME`,
        `T6`.`middleName` AS `MIDDLE_NAME`,
        `T6`.`lastName` AS `LAST_NAME`,
        `T6`.`shortName` AS `SHORT_NAME`,
        `T92`.`categoryName` AS `PROGRAM_CATEGORY`,
        `T71`.`programName` AS `PROGRAM_NAME`,
        `T71`.`id` AS `PROGRAM_ID`,
        `pg`.`groupName` AS `PROGRAM_GROUP_NAME`,
        `T70`.`batchName` AS `BATCH_NAME`,
        `T65`.`programPeriodName` AS `PROGRAM_PERIOD_NAME_NEW`,
        `T10`.`sectionCode` AS `SECTION_CODE`,
        `T93`.`itemValue` AS `INTAKE_YEAR`,
        `T6`.`emailId` AS `EMAIL_ID`,
        `T6`.`alternateEmailId` AS `ALTERNATE_EMAIL_ID`,
        `T6`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `T6`.`mobileNumber` AS `MOBILE_NUMBER`,
        `T25`.`itemValue` AS `RELIGION`,
        `T22`.`itemValue` AS `CASTE_CATEGORY`,
        `T66`.`progBatchSeatConfigId` AS `PROGRAM_BATCH_SEAT_CONFIG_ID`,
        `T3`.`id` AS `ADMISSION_ID`,
        `T70`.`id` AS `PROGRAM_BATCH_ID`,
        `T2`.`id` AS `USER_ID`,
        `T16`.`academyName` AS `ACADEMY_NAME`,
        `T16`.`locationName` AS `LOCATION_NAME`,
        `T100`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `T3`.`status` AS `ADMISSION_STATUS`,
        `T3`.`admissionDate` AS `ADMISSION_DATE`,
        `T70`.`startDate` AS `BATCH_SRART_DATE`,
        `T3`.`activeStatus` AS `STATUS`,
        `T70`.`tillDate` AS `BATCH_TILL_DATE`,
        `T6`.`birthDate` AS `DATE_OF_BIRTH`,
        `gen`.`itemValue` AS `GENDER`,
        `T18`.`firstName` AS `FATHERS_FULL_NAME`,
        `T18`.`firstName` AS `FATHERS_FIRST_NAME`,
        `T18`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `T18`.`lastName` AS `FATHERS_LAST_NAME`,
        `T18`.`emailId` AS `FATHERS_EMAIL_ID`,
        `T18`.`mobileNumber` AS `FATHERS_MOBILE_NUMBER`,
        `T18`.`mobileCountryCode` AS `FATHERS_MOBILE_COUNTRY_CODE`,
        `T30`.`firstName` AS `MOTHERS_FULL_NAME`,
        `T30`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `T30`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `T30`.`lastName` AS `MOTHERS_LAST_NAME`,
        `T30`.`emailId` AS `MOTHERS_EMAIL_ID`,
        `T30`.`mobileNumber` AS `MOTHERS_MOBILE_NUMBER`,
        `T21`.`firstName` AS `GUARDIAN_FULL_NAME`,
        `T30`.`mobileCountryCode` AS `MOTHERS_MOBILE_COUNTRY_CODE`,
        `T21`.`firstName` AS `GUARDIAN_FIRST_NAME`,
        `T21`.`middleName` AS `GUARDIAN_MIDDLE_NAME`,
        `T21`.`lastName` AS `GUARDIAN_LAST_NAME`,
        `T21`.`emailId` AS `GUARDIAN_EMAIL_ID`,
        `T21`.`mobileNumber` AS `GUARDIAN_MOBILE_NUMBER`,
        `T21`.`mobileCountryCode` AS `GUARDIAN_MOBILE_COUNTRY_CODE`,
        `T60`.`addressText` AS `ADDRESS`,
        `T61`.`cityName` AS `CITY_NAME`,
        `T91`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `T62`.`countryName` AS `COUNTRY_NAME`,
        `T23`.`itemValue` AS `NATIONALITY`,
        `T97`.`value` AS `HOME_LANGUAGE`,
        `T99`.`salutationName` AS `FATHERS_SALUTATION_NAME`,
        `T72`.`seatName` AS `SEAT_TYPE`,
        `T6`.`birthDate` AS `AGE`,
        `T6`.`nationalID` AS `NATIONAL_ID`,
        `T101`.`printName` AS `ADVISOR_NAME`,
        `T1`.`userId` AS `APPLICATION_CREATION_SOURCE`,
        `T102`.`salutationName` AS `GUARDIAN_SALUTATION_NAME`,
        `T98`.`salutationName` AS `MOTHERS_SALUTATION_NAME`,
        `T16`.`id` AS `ACADEMY_LOCATION_ID`,
        `T2`.`printName` AS `Print_Name`,
        `ss`.`itemValue` AS `Student_Status`,
        `percd`.`cf7` AS `High_School`,
        `percd`.`cf10` AS `High_School_Province`,
        `T66`.`exitDate` AS `Graduate_Date`,
        `T71`.`programCode` AS `programcode`,
        `T71`.`programSequence` AS `programSequence`,
        `T6`.`printNameOtherLanguage` AS `printNameOtherLanguage`
    FROM
        ((((((((((((((((((((((((((((((((((((((`students` `T1`
        LEFT JOIN `users` `T2` ON ((`T1`.`userId` = `T2`.`id`)))
        LEFT JOIN `persons` `T6` ON ((`T6`.`id` = `T1`.`personId`)))
        LEFT JOIN `gender` `gen` ON ((`gen`.`id` = `T6`.`genderId`)))
        LEFT JOIN `admission` `T3` ON ((`T3`.`studentId` = `T1`.`userId`)))
        LEFT JOIN `user_academy_locations` `T15` ON (((`T2`.`id` = `T15`.`userId`)
            AND (`T15`.`whetherPrimary` = 1))))
        LEFT JOIN `person_relationships` `T20` ON (((`T6`.`id` = `T20`.`personId`)
            AND (`T20`.`relationship` = 'GUARDIAN')
            AND (`T20`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `T17` ON (((`T6`.`id` = `T17`.`personId`)
            AND (`T17`.`relationship` = 'FATHER')
            AND (`T17`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `T29` ON (((`T6`.`id` = `T29`.`personId`)
            AND (`T29`.`relationship` = 'MOTHER')
            AND (`T29`.`whetherDeleted` = 0))))
        LEFT JOIN `users` `T101` ON ((`T101`.`id` = `T6`.`advisorId`)))
        LEFT JOIN `student_hostel_requirement` `T100` ON (((`T100`.`personId` = `T6`.`id`)
            AND (`T100`.`whetherDeleted` = 0))))
        LEFT JOIN `nationalities` `T23` ON ((`T6`.`nationalityId` = `T23`.`id`)))
        LEFT JOIN `person_addresses` `T59` ON (((`T59`.`personId` = `T6`.`id`)
            AND (`T59`.`whetherPrimary` = 1)
            AND (`T59`.`whetherDeleted` = 0))))
        LEFT JOIN `religions` `T25` ON ((`T6`.`religionId` = `T25`.`id`)))
        LEFT JOIN `caste_categories` `T22` ON ((`T6`.`castCategoryId` = `T22`.`id`)))
        LEFT JOIN `drop_down` `T97` ON ((`T6`.`homeLanguage` = `T97`.`id`)))
        LEFT JOIN `program_batch_students` `T66` ON (((`T66`.`admissionId` = `T3`.`id`)
            AND (`T66`.`isCurrentSection` = 1)
            AND (`T66`.`isCurrentPeriod` = 1))))
        LEFT JOIN `academy_location` `T16` ON ((`T16`.`id` = `T15`.`academyLocationId`)))
        LEFT JOIN `persons` `T21` ON (((`T21`.`id` = `T20`.`relatedPersonId`)
            AND (`T20`.`relationship` = 'GUARDIAN')
            AND (`T20`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `T18` ON (((`T18`.`id` = `T17`.`relatedPersonId`)
            AND (`T17`.`relationship` = 'FATHER')
            AND (`T18`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `T30` ON (((`T30`.`id` = `T29`.`relatedPersonId`)
            AND (`T29`.`relationship` = 'MOTHER')
            AND (`T29`.`whetherDeleted` = 0))))
        LEFT JOIN `address` `T60` ON ((`T60`.`id` = `T59`.`addressId`)))
        LEFT JOIN `prog_batch_seat_config` `T74` ON ((`T74`.`id` = `T66`.`progBatchSeatConfigId`)))
        LEFT JOIN `prog_batch_period_config` `T65` ON ((`T65`.`id` = `T66`.`progBatchPeriodConfigId`)))
        LEFT JOIN `sections` `T10` ON ((`T10`.`id` = `T66`.`sectionId`)))
        LEFT JOIN `salutations` `T102` ON ((`T102`.`id` = `T21`.`salutationId`)))
        LEFT JOIN `salutations` `T99` ON ((`T99`.`id` = `T18`.`salutationId`)))
        LEFT JOIN `salutations` `T98` ON ((`T98`.`id` = `T30`.`salutationId`)))
        LEFT JOIN `city` `T61` ON ((`T61`.`id` = `T60`.`cityId`)))
        LEFT JOIN `seat_types` `T72` ON ((`T72`.`id` = `T74`.`seatTypeId`)))
        LEFT JOIN `batches` `T70` ON ((`T70`.`id` = `T65`.`programBatchId`)))
        LEFT JOIN `country` `T62` ON ((`T62`.`id` = `T61`.`countryId`)))
        LEFT JOIN `country_region` `T91` ON ((`T91`.`id` = `T61`.`countryRegionId`)))
        LEFT JOIN `programs` `T71` ON ((`T71`.`id` = `T70`.`programId`)))
        LEFT JOIN `program_group` `pg` ON ((`pg`.`id` = `T71`.`programGroupId`)))
        LEFT JOIN `intake_year` `T93` ON ((`T93`.`id` = `T70`.`intakeYearId`)))
        LEFT JOIN `program_category` `T92` ON ((`T92`.`id` = `T71`.`programCategoryId`)))
        LEFT JOIN `student_status` `ss` ON ((`ss`.`id` = `T6`.`studentStatusId`)))
        LEFT JOIN `person_cd` `percd` ON ((`percd`.`personId` = `T6`.`id`)))
    WHERE
        ((`T2`.`status` = 1)
            AND (`T3`.`activeStatus` = 1))
    GROUP BY `T1`.`userId`;
END IF;
/** view 21- student_list_view End */

/** view -22 studyprogram_details start */
DROP VIEW IF EXISTS studyprogram_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='studyprogram_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `studyprogram_details` AS
    SELECT DISTINCT
        `al`.`academyCode` AS `Faculty_Code`,
        `prog`.`programCode` AS `Study_Program_Code`,
        `prog`.`programName` AS `Study_Program_Name`,
        `pg`.`groupName` AS `Study_Program_Group`,
        `prog`.`programMarkGrade` AS `Study_Program_Marks_Grades`,
        `mode`.`itemValue` AS `Mode_of_Delivery`,
        (CASE
            WHEN (`prog`.`status` = 'O') THEN 'Open'
            WHEN (`prog`.`status` = 'C') THEN 'Close'
            ELSE `prog`.`status`
        END) AS `status`
    FROM
        (((`programs` `prog`
        JOIN `academy_location` `al` ON ((`al`.`id` = `prog`.`academyLocationId`)))
        JOIN `program_group` `pg` ON ((`pg`.`id` = `prog`.`programGroupId`)))
        LEFT JOIN `mode_of_delivery` `mode` ON ((`mode`.`id` = `prog`.`modeOfDeliveryId`)));
END IF;
/** view 22- studyprogram_details End */

/** view -23 workforce_details start */
DROP VIEW IF EXISTS workforce_details; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='workforce_details')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `workforce_details` AS
    SELECT DISTINCT
        `usr`.`code` AS `Workforce_ID`,
        `usr`.`firstName` AS `firstName`,
        `usr`.`middleName` AS `middleName`,
        `usr`.`lastName` AS `lastName`,
        `gen`.`itemValue` AS `gender`,
        `nat`.`itemValue` AS `Nationality`,
        `des`.`itemValue` AS `Designation`,
        `dept`.`deptName` AS `Department`,
        `stf`.`joiningDate` AS `Date_of_Joining`,
        `stf`.`exitDate` AS `Date_of_Exit`,
        `ug`.`userGroupName` AS `Group_Name`,
        (CASE
            WHEN (`ug`.`userGroupName` IN ('lecturer' , 'faculty')) THEN 'true'
            ELSE 'False'
        END) AS `Whether_Lecturer`,
        `ft`.`itemValue` AS `Faculty_Type`
    FROM
        ((((((((`staffs` `stf`
        JOIN `users` `usr` ON ((`usr`.`id` = `stf`.`userId`)))
        JOIN `persons` `per` ON ((`stf`.`personId` = `per`.`id`)))
        JOIN `gender` `gen` ON ((`gen`.`id` = `per`.`genderId`)))
        JOIN `nationalities` `nat` ON ((`nat`.`id` = `per`.`nationalityId`)))
        JOIN `designations` `des` ON ((`des`.`id` = `stf`.`designationId`)))
        JOIN `department` `dept` ON ((`dept`.`id` = `stf`.`departmentId`)))
        JOIN `user_groups` `ug` ON ((`ug`.`id` = `usr`.`userGroupId`)))
        LEFT JOIN `faculty_type` `ft` ON ((`ft`.`id` = `stf`.`facultyTypeId`)));
END IF;
/** view 23- workforce_details End */

/** view -24 sap_applicant_detail_view start */
DROP VIEW IF EXISTS sap_applicant_detail_view; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='sap_applicant_detail_view')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `sap_applicant_detail_view` AS
    SELECT 
        `aper`.`firstName` AS `First_Name`,
        `aper`.`middleName` AS `Middle_Name`,
        `aper`.`lastName` AS `Last_Name`,
        `gen`.`itemValue` AS `Gender`,
        `aper`.`birthDate` AS `Date_Of_Birth`,
        `cntry`.`countryName` AS `Country`,
        `aper`.`nationalID` AS `Id_Card_No`,
        `app`.`code` AS `ID`,
        CONCAT(`aper`.`phoneAreaCode`,
                ' ',
                `aper`.`phoneNo`) AS `Phone_No`,
        `aper`.`mobileNumber` AS `Mobile_No`,
        `aper`.`emailId` AS `Email`,
        `aper`.`alternateEmailId` AS `Alt_Email`,
        `aper`.`printName` AS `Name_In_Bank`,
        `apbd`.`accountNumber` AS `Bank_Acc_No`,
        `at`.`itemValue` AS `Bank_Acc_Type`,
        `apbd`.`bankName` AS `Bank_Name`,
        `apbd`.`branchName` AS `Bank_Branch_Name`,
        `apbd`.`IFSCode` AS `Bank_IFSC_Code`,
        `pgrp`.`groupName` AS `Program_Group`,
        `aper`.`lastUpdate` AS `Last_Update`,
        `apbd`.`beneficiaryName` AS `beneficiaryName`,
        `apbd`.`beneficiaryName` AS `beneficiaryNameOtherLanguage`,
        `aper`.`printNameOtherLanguage` AS `printNameOtherLanguage`,
        `st`.`seatName` AS `seat_type`,
        `aad`.`addressText` AS `Address`
    FROM
        ((((((((((`application` `app`
        JOIN `applicant_person` `aper` ON ((`app`.`applicantPersonId` = `aper`.`id`)))
        LEFT JOIN `gender` `gen` ON ((`aper`.`genderId` = `gen`.`id`)))
        LEFT JOIN `country` `cntry` ON ((`aper`.`countryId` = `cntry`.`id`)))
        LEFT JOIN `applicant_bank_details` `apbd` ON ((`aper`.`bankDetailId` = `apbd`.`id`)))
        LEFT JOIN `account_type` `at` ON ((`apbd`.`accountTypeId` = `at`.`id`)))
        LEFT JOIN `program_group` `pgrp` ON ((`app`.`programGroupId` = `pgrp`.`id`)))
        LEFT JOIN `application_program` `ap` ON ((`ap`.`applicationId` = `app`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `ap`.`progBatchSeatConfigId`)))
        LEFT JOIN `seat_types` `st` ON ((`st`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `applicant_address` `aad` ON ((`aad`.`applicantPersonId` = `aper`.`id`)))
    GROUP BY `aper`.`id`;
END IF;
/** view 24- sap_applicant_detail_view End */


/** view -25 sap_applicant_detail_view start */
DROP VIEW IF EXISTS sap_student_detail_view; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='sap_student_detail_view')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `sap_student_detail_view` AS
    SELECT 
        `usr`.`firstName` AS `First_Name`,
        `usr`.`middleName` AS `Middle_Name`,
        `usr`.`lastName` AS `Last_Name`,
        `usr`.`printName` AS `Print_Name`,
        `gen`.`itemValue` AS `Gender`,
        `per`.`birthDate` AS `Date_Of_Birth`,
        `cntry`.`countryName` AS `Country`,
        `per`.`nationalID` AS `Id_Card_No`,
        `usr`.`code` AS `ID`,
        `usr`.`status` AS `Status`,
        `adr`.`addressText` AS `Address`,
        CONCAT(`per`.`phoneAreaCode`,
                ' ',
                `per`.`phoneNo`) AS `Phone_No`,
        `per`.`mobileNumber` AS `Mobile_No`,
        `per`.`emailId` AS `Email`,
        `per`.`alternateEmailId` AS `Alt_Email`,
        `usr`.`printName` AS `Name_In_Bank`,
        `bd`.`accountNumber` AS `Bank_Acc_No`,
        `at`.`itemValue` AS `Bank_Acc_Type`,
        `bd`.`bankName` AS `Bank_Name`,
        `bd`.`branchName` AS `Bank_Branch_Name`,
        `bd`.`IFSCode` AS `Bank_IFSC_Code`,
        `stp`.`seatName` AS `Seat_Type`,
        GROUP_CONCAT(`fpd`.`payerType`
            SEPARATOR ',') AS `FeePayerType`,
        GROUP_CONCAT(`fpd`.`firstName`
            SEPARATOR ',') AS `NameOfContactPerson`,
        GROUP_CONCAT(`fpd`.`contactPerson`
            SEPARATOR ',') AS `NameOfCorporateContactPerson`,
        GROUP_CONCAT(`fpd`.`companyName`
            SEPARATOR ',') AS `NameOfCompany`,
        GROUP_CONCAT(`fpadd`.`addressText`
            SEPARATOR ',') AS `FeePayerAddress`,
        GROUP_CONCAT(`fpd`.`companyAddress`
            SEPARATOR ',') AS `CompanyAddress`,
        GROUP_CONCAT(`fpd`.`corporateId`
            SEPARATOR ',') AS `CorporateId`,
        `pgrp`.`groupName` AS `Program_Group`,
        `per`.`lastUpdate` AS `Last_Update`,
        `prog`.`programCode` AS `programcode`,
        `ir`.`itemCode` AS `intake_year`,
        `per`.`printNameOtherLanguage` AS `printnameotherlanguage`,
        `bd`.`beneficiaryName` AS `beneficiaryName`,
        `bd`.`beneficiaryNameOtherLanguage` AS `beneficiaryNameOtherLanguage`
    FROM
        ((((((((((((((((((`students` `std`
        JOIN `users` `usr` ON ((`std`.`userId` = `usr`.`id`)))
        JOIN `persons` `per` ON ((`std`.`personId` = `per`.`id`)))
        LEFT JOIN `person_addresses` `peradd` ON ((`per`.`id` = `peradd`.`personId`)))
        LEFT JOIN `address` `adr` ON ((`adr`.`id` = `peradd`.`addressId`)))
        JOIN `gender` `gen` ON ((`per`.`genderId` = `gen`.`id`)))
        LEFT JOIN `country` `cntry` ON ((`per`.`countryId` = `cntry`.`id`)))
        LEFT JOIN `bank_details` `bd` ON ((`per`.`bankDetailId` = `bd`.`id`)))
        LEFT JOIN `account_type` `at` ON ((`bd`.`accountTypeId` = `at`.`id`)))
        JOIN `admission` `adm` ON ((`std`.`userId` = `adm`.`studentId`)))
        JOIN `program_batch_students` `pbs` ON ((`pbs`.`admissionId` = `adm`.`id`)))
        JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `pbs`.`progBatchSeatConfigId`)))
        JOIN `seat_types` `stp` ON ((`stp`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `fee_payer_detail` `fpd` ON ((`per`.`id` = `fpd`.`personId`)))
        JOIN `programs` `prog` ON ((`adm`.`programId` = `prog`.`id`)))
        JOIN `program_group` `pgrp` ON ((`prog`.`programGroupId` = `pgrp`.`id`)))
        LEFT JOIN `address` `fpadd` ON ((`fpd`.`addressId` = `fpadd`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`btc`.`id` = `pbsc`.`programBatchId`)))
        LEFT JOIN `intake_year` `ir` ON ((`ir`.`id` = `btc`.`intakeYearId`)))
    WHERE
        ((`pbs`.`isCurrentPeriod` = 1)
            AND (`pbs`.`isCurrentSection` = 1)
            AND (`pbs`.`isPeriodCompleted` = 0)
            AND (`peradd`.`whetherPrimary` = 1))
    GROUP BY `usr`.`id`;
END IF;
/** view 25- sap_student_detail_view End */

/** view -26 credit_note_view_sapb1 start */
DROP VIEW IF EXISTS credit_note_view_sapb1; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='credit_note_view_sapb1')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `credit_note_view_sapb1` AS
    SELECT 
        `bfprs`.`id` AS `CreditNoteFeeHeadId`,
        `bh`.`billNo` AS `CreditNoteNo`,
        `bh`.`raiseBillType` AS `CreditNoteType`,
        `but`.`billedUserType` AS `CreditNoteFor`,
        `c`.`currencyCode` AS `CreditNoteCurrency`,
        `bh`.`billingDate` AS `CreditNoteDate`,
        `bh`.`decisionNumber` AS `CreditNoteDecisionNumber`,
        `bh`.`dateOfDecision` AS `CreditNoteDateOfDecision`,
        (CASE
            WHEN (`bh`.`applicantId` IS NOT NULL) THEN CONCAT(`a`.`code`, '/', `ap`.`printName`)
            WHEN
                (`bh`.`studentId` IS NOT NULL)
            THEN
                CONCAT(`st_user`.`code`,
                        '/',
                        `st_user`.`printName`)
            WHEN
                (`bh`.`sponsorId` IS NOT NULL)
            THEN
                CONCAT(`sp`.`sponsorshipCode`,
                        '/',
                        `sp`.`sponsorName`)
            WHEN (`bh`.`userId` IS NOT NULL) THEN CONCAT(`u`.`code`, '/', `u`.`printName`)
            ELSE NULL
        END) AS `CreditNoteOwner`,
        (SELECT 
                `pbpc`.`programPeriodName`
            FROM
                (((`program_batch_students` `pbs`
                LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbs`.`progBatchPeriodConfigId` = `pbpc`.`id`)))
                LEFT JOIN `admission` `adm` ON ((`adm`.`id` = `pbs`.`admissionId`)))
                LEFT JOIN `students` `st` ON ((`st`.`userId` = `adm`.`studentId`)))
            WHERE
                ((`st`.`userId` = `bh`.`studentId`)
                    AND (`bh`.`billingDate` >= `pbpc`.`programPeriodStart`)
                    AND (`bh`.`billingDate` <= `pbpc`.`programPeriodEnd`))
            GROUP BY `st`.`userId`) AS `Semester`,
        CONCAT(`pgm`.`programName`,
                '#',
                `b`.`batchName`,
                '#',
                `seat`.`seatName`) AS `programIntakeSeatType`,
        `pgmb`.`groupName` AS `ProgramGroup`,
        `pgm`.`programCode` AS `ProgramCode`,
        `ou`.`code` AS `CreditNoteIAU`,
        `bh`.`dueDate` AS `DueDate`,
        `fh`.`feeHeadName` AS `FeeHeadName`,
        `bfprs`.`billableAmount` AS `Amount`,
        `bh`.`reasonForManualBill` AS `ReasonForManualBilling`,
        `fpt`.`feePlanType` AS `FeePlanType`,
        `fp`.`feePlanId` AS `FeePlanId`,
        `fpr`.`feeRuleDesc` AS `FeePlanRule`,
        `fsm`.`stageName` AS `FeePlanStage`,
        `bh`.`billStatus` AS `BillStatus`,
        `sch`.`scholarshipName` AS `ScholarshipName`,
        (CASE
            WHEN (`sch`.`scholarshipType` = 'EXT') THEN 'External'
            WHEN (`sch`.`scholarshipType` = 'INT') THEN 'Internal'
            ELSE NULL
        END) AS `ScholarshipType`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`payerType`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `FeePayerType`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCompany`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`firstName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`contactPerson`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCorporateContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT CONCAT(`ad`.`addressText`)
                        SEPARATOR '#')
            FROM
                (((`fee_payer_detail` `fpd`
                LEFT JOIN `address` `ad` ON ((`ad`.`id` = `fpd`.`addressId`)))
                LEFT JOIN `city` `ci` ON ((`ci`.`id` = `ad`.`cityId`)))
                LEFT JOIN `country` `cou` ON ((`cou`.`id` = `ci`.`countryId`)))
            WHERE
                ((`fpd`.`personId` = `p`.`id`)
                    AND (`fpd`.`addressId` IS NOT NULL))) AS `Address`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyAddress`
                        SEPARATOR '#')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CompanyAddress`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`corporateId`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CorporateId`,
        `bh`.`lastUpdate` AS `LastUpdate`,
        `so`.`organizationName` AS `organizationname`,
        `p`.`printNameOtherLanguage` AS `printNameOtherLanguage`
    FROM
        (((((((((((((((((((((((((`bill_fee_plan_rule_stage` `bfprs`
        LEFT JOIN `bill_header` `bh` ON ((`bfprs`.`billId` = `bh`.`id`)))
        LEFT JOIN `currency` `c` ON ((`c`.`id` = `bh`.`currencyId`)))
        LEFT JOIN `students` `st` ON ((`st`.`userId` = `bh`.`studentId`)))
        LEFT JOIN `sponsors` `sp` ON ((`sp`.`id` = `bh`.`sponsorId`)))
        LEFT JOIN `organization_units` `ou` ON ((`bh`.`iauId` = `ou`.`id`)))
        LEFT JOIN `application` `a` ON ((`a`.`id` = `bh`.`applicantId`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `a`.`applicantPersonId`)))
        LEFT JOIN `users` `u` ON ((`u`.`id` = `bh`.`userId`)))
        LEFT JOIN `users` `st_user` ON ((`st_user`.`id` = `st`.`userId`)))
        LEFT JOIN `persons` `p` ON ((`p`.`id` = `st`.`personId`)))
        LEFT JOIN `billed_user_type` `but` ON ((`but`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `bh`.`programBatchSeatConfigId`)))
        LEFT JOIN `batches` `b` ON ((`b`.`id` = `pbsc`.`programBatchId`)))
        LEFT JOIN `programs` `pgm` ON ((`b`.`programId` = `pgm`.`id`)))
        LEFT JOIN `program_group` `pgmb` ON ((`pgmb`.`id` = `pgm`.`programGroupId`)))
        LEFT JOIN `seat_types` `seat` ON ((`seat`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`fshc`.`id` = `bfprs`.`feeStageHeadConfigId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fprs`.`id` = `fshc`.`feePlanRuleStageId`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fpt`.`id` = `fp`.`feePlanType`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fsm`.`id` = `fprs`.`stageId`)))
        LEFT JOIN `scholarship` `sch` ON ((`sch`.`id` = `bh`.`scholarshipId`)))
        LEFT JOIN `scholarship_organizations` `so` ON ((`so`.`id` = `sch`.`scholarshipOrganizationId`)))
    WHERE
        (`bh`.`raiseBillCategory` = 'BILL_PAYABLE')
    GROUP BY `bfprs`.`id`;
END IF;
/** view 26- credit_note_view_sapb1 End */

/** view -27 debit_note_view_sapb1 start */
DROP VIEW IF EXISTS debit_note_view_sapb1;  

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='debit_note_view_sapb1')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `debit_note_view_sapb1` AS
    SELECT 
        `bfprs`.`id` AS `DebitNoteFeeHeadId`,
        `bh`.`billNo` AS `DebitNoteNo`,
        `bh`.`raiseBillType` AS `DebitNoteType`,
        `but`.`billedUserType` AS `DebitNoteFor`,
        `c`.`currencyCode` AS `DebitNoteCurrency`,
        `bh`.`billingDate` AS `DebitNoteDate`,
        (CASE
            WHEN (`bh`.`applicantId` IS NOT NULL) THEN CONCAT(`a`.`code`, '/', `ap`.`printName`)
            WHEN
                (`bh`.`studentId` IS NOT NULL)
            THEN
                CONCAT(`st_user`.`code`,
                        '/',
                        `st_user`.`printName`)
            WHEN
                (`bh`.`sponsorId` IS NOT NULL)
            THEN
                CONCAT(`sp`.`sponsorshipCode`,
                        '/',
                        `sp`.`sponsorName`)
            WHEN (`bh`.`userId` IS NOT NULL) THEN CONCAT(`u`.`code`, '/', `u`.`printName`)
            ELSE NULL
        END) AS `DebitNoteOwner`,
        (SELECT 
                `pbpc`.`programPeriodName`
            FROM
                (((`program_batch_students` `pbs`
                LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbs`.`progBatchPeriodConfigId` = `pbpc`.`id`)))
                LEFT JOIN `admission` `adm` ON ((`adm`.`id` = `pbs`.`admissionId`)))
                LEFT JOIN `students` `st` ON ((`st`.`userId` = `adm`.`studentId`)))
            WHERE
                ((`st`.`userId` = `bh`.`studentId`)
                    AND (`bh`.`billingDate` >= `pbpc`.`programPeriodStart`)
                    AND (`bh`.`billingDate` <= `pbpc`.`programPeriodEnd`))
            GROUP BY `st`.`userId`) AS `Semester`,
        CONCAT(`pgm`.`programName`,
                '#',
                `b`.`batchName`,
                '#',
                `seat`.`seatName`) AS `programIntakeSeatType`,
        `pgmg`.`groupName` AS `ProgramGroup`,
        `pgm`.`programCode` AS `ProgramCode`,
        `ou`.`code` AS `DebitNoteIAU`,
        `bh`.`dueDate` AS `DueDate`,
        `fh`.`feeHeadName` AS `FeeHeadName`,
        `bfprs`.`billableAmount` AS `Amount`,
        `bh`.`reasonForManualBill` AS `ReasonForManualBilling`,
        `fpt`.`feePlanType` AS `FeePlanType`,
        `fp`.`feePlanId` AS `FeePlanId`,
        `fpr`.`feeRuleDesc` AS `FeePlanRule`,
        `fsm`.`stageName` AS `FeePlanStage`,
        `bh`.`billStatus` AS `BillStatus`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`payerType`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `FeePayerType`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCompany`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`firstName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`contactPerson`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCorporateContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT CONCAT(`ad`.`addressText`)
                        SEPARATOR '#')
            FROM
                (((`fee_payer_detail` `fpd`
                LEFT JOIN `address` `ad` ON ((`ad`.`id` = `fpd`.`addressId`)))
                LEFT JOIN `city` `ci` ON ((`ci`.`id` = `ad`.`cityId`)))
                LEFT JOIN `country` `cou` ON ((`cou`.`id` = `ci`.`countryId`)))
            WHERE
                ((`fpd`.`personId` = `p`.`id`)
                    AND (`fpd`.`addressId` IS NOT NULL))) AS `Address`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyAddress`
                        SEPARATOR '#')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CompanyAddress`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`corporateId`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CorporateId`,
        `bh`.`lastUpdate` AS `LastUpdate`,
        `p`.`printNameOtherLanguage` AS `printNameOtherLanguage`
    FROM
        (((((((((((((((((((((((`bill_fee_plan_rule_stage` `bfprs`
        LEFT JOIN `bill_header` `bh` ON ((`bfprs`.`billId` = `bh`.`id`)))
        LEFT JOIN `currency` `c` ON ((`c`.`id` = `bh`.`currencyId`)))
        LEFT JOIN `students` `st` ON ((`st`.`userId` = `bh`.`studentId`)))
        LEFT JOIN `sponsors` `sp` ON ((`sp`.`id` = `bh`.`sponsorId`)))
        LEFT JOIN `organization_units` `ou` ON ((`bh`.`iauId` = `ou`.`id`)))
        LEFT JOIN `application` `a` ON ((`a`.`id` = `bh`.`applicantId`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `a`.`applicantPersonId`)))
        LEFT JOIN `users` `u` ON ((`u`.`id` = `bh`.`userId`)))
        LEFT JOIN `users` `st_user` ON ((`st_user`.`id` = `st`.`userId`)))
        LEFT JOIN `persons` `p` ON ((`p`.`id` = `st`.`personId`)))
        LEFT JOIN `billed_user_type` `but` ON ((`but`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `bh`.`programBatchSeatConfigId`)))
        LEFT JOIN `batches` `b` ON ((`b`.`id` = `pbsc`.`programBatchId`)))
        LEFT JOIN `programs` `pgm` ON ((`b`.`programId` = `pgm`.`id`)))
        LEFT JOIN `program_group` `pgmg` ON ((`pgmg`.`id` = `pgm`.`programGroupId`)))
        LEFT JOIN `seat_types` `seat` ON ((`seat`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`fshc`.`id` = `bfprs`.`feeStageHeadConfigId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fprs`.`id` = `fshc`.`feePlanRuleStageId`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fpt`.`id` = `fp`.`feePlanType`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fsm`.`id` = `fprs`.`stageId`)))
    WHERE
        (`bh`.`raiseBillCategory` = 'BILL_RECEIVABLE')
    GROUP BY `bfprs`.`id`;
END IF;
/** view 27- debit_note_view_sapb1 End */

/** view -28 receipt_view_sapb1 start */
DROP VIEW IF EXISTS receipt_view_sapb1; 

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='receipt_view_sapb1')) THEN  
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `receipt_view_sapb1` AS
    SELECT 
        `rh`.`voucherMode` AS `VoucherType`,
        `rh`.`receiptType` AS `ReceiptMode`,
        `rh`.`receiptNo` AS `ReceiptNo`,
        `but`.`raiseBillType` AS `ReceiptType`,
        `but`.`billedUserType` AS `ReceiptFor`,
        `ou`.`code` AS `ReceivingIAU`,
        `c`.`currencyCode` AS `ReceivingCurrency`,
        `b`.`accountNo` AS `OurBankAccount`,
        `rh`.`transactionDate` AS `ReceiptDate`,
        (CASE
            WHEN (`rh`.`applicantId` IS NOT NULL) THEN CONCAT(`a`.`code`, '/', `ap`.`printName`)
            WHEN
                (`rh`.`studentId` IS NOT NULL)
            THEN
                CONCAT(`st_user`.`code`,
                        '/',
                        `st_user`.`printName`)
            WHEN
                (`rh`.`sponsorId` IS NOT NULL)
            THEN
                CONCAT(`sp`.`sponsorshipCode`,
                        '/',
                        `sp`.`sponsorName`)
            WHEN (`rh`.`userId` IS NOT NULL) THEN CONCAT(`u`.`code`, '/', `u`.`printName`)
            ELSE NULL
        END) AS `ReceiptOwner`,
        (CASE
            WHEN
                (`rh`.`applicantId` IS NOT NULL)
            THEN
                (SELECT 
                        `pgmg`.`groupName`
                    FROM
                        (`program_group` `pgmg`
                        LEFT JOIN `application` `app` ON ((`app`.`programGroupId` = `pgmg`.`id`)))
                    WHERE
                        (`app`.`id` = `a`.`id`))
            WHEN
                (`rh`.`studentId` IS NOT NULL)
            THEN
                (SELECT 
                        `pgmg`.`groupName`
                    FROM
                        ((`program_group` `pgmg`
                        LEFT JOIN `programs` `pgm` ON ((`pgmg`.`id` = `pgm`.`programGroupId`)))
                        LEFT JOIN `admission` `adm` ON ((`adm`.`programId` = `pgm`.`id`)))
                    WHERE
                        (`adm`.`studentId` = `st`.`userId`)
                    GROUP BY `st`.`userId`)
            ELSE NULL
        END) AS `ProgramGroup`,
        IFNULL(GROUP_CONCAT(DISTINCT `fpm`.`paymentModeName`
                    SEPARATOR ','),
                NULL) AS `PaymentMode`,
        IFNULL(GROUP_CONCAT(DISTINCT `rpr`.`instrumentNo`
                    SEPARATOR ','),
                NULL) AS `InstrumentNo`,
        IFNULL(GROUP_CONCAT(DISTINCT `rpr`.`instrumentDate`
                    SEPARATOR ','),
                NULL) AS `InstrumentDate`,
        (CASE
            WHEN (`rpr`.`amount` IS NULL) THEN `rh`.`amount`
            ELSE `rpr`.`amount`
        END) AS `Amount`,
        `rpr`.`bankChargesAmount` AS `BankChargesAmount`,
        `rpr`.`bankChargesPercentage` AS `BankChargesPercentage`,
        `bdom`.`bankName` AS `DrawnOnBank`,
        `rh`.`narration` AS `Narration`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `bh`.`billNo`
                        SEPARATOR ',')
            FROM
                ((`fee_adjustment_master` `fam`
                LEFT JOIN `fee_adjustment_details` `fad` ON ((`fam`.`id` = `fad`.`adjustmentMasterId`)))
                LEFT JOIN `bill_header` `bh` ON ((`bh`.`id` = `fad`.`billHeaderId`)))
            WHERE
                ((`fam`.`receiptHeaderId` = `rh`.`id`)
                    OR (`fam`.`instrumentId` = `rpr`.`id`))) AS `SettledDebitNote`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`payerType`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `FeePayerType`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCompany`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`firstName`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`contactPerson`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `NameOfCorporateContactPerson`,
        (SELECT 
                GROUP_CONCAT(DISTINCT CONCAT(`ad`.`addressText`)
                        SEPARATOR '#')
            FROM
                (((`fee_payer_detail` `fpd`
                LEFT JOIN `address` `ad` ON ((`ad`.`id` = `fpd`.`addressId`)))
                LEFT JOIN `city` `ci` ON ((`ci`.`id` = `ad`.`cityId`)))
                LEFT JOIN `country` `cou` ON ((`cou`.`id` = `ci`.`countryId`)))
            WHERE
                ((`fpd`.`personId` = `p`.`id`)
                    AND (`fpd`.`addressId` IS NOT NULL))) AS `Address`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`companyAddress`
                        SEPARATOR '#')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CompanyAddress`,
        (SELECT 
                GROUP_CONCAT(DISTINCT `fpd`.`corporateId`
                        SEPARATOR ',')
            FROM
                `fee_payer_detail` `fpd`
            WHERE
                (`fpd`.`personId` = `p`.`id`)) AS `CorporateId`,
        `rh`.`lastUpdate` AS `LastUpdate`,
        `p`.`printNameOtherLanguage` AS `printNameOtherLanguage`,
        `prog`.`programCode` AS `Program_Code`,
        `iy`.`itemValue` AS `Intake_Year`,
        `pbpc`.`programPeriodName` AS `Semester`,
        `stp`.`seatName` AS `Seat_Type`
    FROM
        (((((((((((((((((((((((`receipt_header` `rh`
        LEFT JOIN `receipt_payment_instrument` `rpr` ON ((`rpr`.`receiptHeaderId` = `rh`.`id`)))
        LEFT JOIN `users` `u` ON ((`rh`.`userId` = `u`.`id`)))
        LEFT JOIN `sponsors` `sp` ON ((`rh`.`sponsorId` = `sp`.`id`)))
        LEFT JOIN `application` `a` ON ((`rh`.`applicantId` = `a`.`id`)))
        LEFT JOIN `applicant_person` `ap` ON ((`a`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `students` `st` ON ((`st`.`userId` = `rh`.`studentId`)))
        LEFT JOIN `users` `st_user` ON ((`rh`.`studentId` = `st_user`.`id`)))
        LEFT JOIN `persons` `p` ON ((`p`.`id` = `st`.`personId`)))
        LEFT JOIN `billed_user_type` `but` ON ((`but`.`id` = `rh`.`receiptFor`)))
        LEFT JOIN `organization_units` `ou` ON ((`rh`.`iauId` = `ou`.`id`)))
        LEFT JOIN `currency` `c` ON ((`c`.`id` = `rh`.`currencyId`)))
        LEFT JOIN `bank` `b` ON ((`b`.`id` = `rh`.`depositedBank`)))
        LEFT JOIN `fee_payment_modes` `fpm` ON ((`fpm`.`id` = `rpr`.`paymentMode`)))
        LEFT JOIN `bank_drawn_on_master` `bdom` ON ((`bdom`.`id` = `rpr`.`instrumentBank`)))
        LEFT JOIN `bank_charges_history` `bch` ON ((`rpr`.`bankChargesHistoryId` = `bch`.`id`)))
        LEFT JOIN `admission` `adm1` ON ((`st`.`userId` = `adm1`.`studentId`)))
        LEFT JOIN `programs` `prog` ON ((`adm1`.`programId` = `prog`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`adm1`.`batchId` = `btc`.`id`)))
        LEFT JOIN `intake_year` `iy` ON ((`iy`.`id` = `btc`.`intakeYearId`)))
        LEFT JOIN `program_batch_students` `pbs` ON ((`pbs`.`admissionId` = `adm1`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `pbs`.`progBatchSeatConfigId`)))
        LEFT JOIN `seat_types` `stp` ON ((`stp`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbs`.`progBatchPeriodConfigId` = `pbpc`.`id`)))
    GROUP BY `rh`.`id` , `rpr`.`id`;
END IF;
/** view 28- receipt_view_sapb1 End */




END $$
CALL V20210601104041__Create_VGU_Views () $$ 
DROP PROCEDURE IF EXISTS V20210601104041__Create_VGU_Views $$ 
DELIMITER ;
