DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708164417__Create_Applicant_view $$
CREATE PROCEDURE V20210708164417__Create_Applicant_view()
BEGIN

DROP VIEW IF EXISTS applicant_view;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='applicant_view')) THEN 
DROP VIEW IF EXISTS applicant_view;
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `applicant_view` AS
    SELECT 
        `appl`.`code` AS `code`,
        `ap`.`externalSysRefOne` AS `sunumber`,
        `ir`.`itemValue` AS `applicationYear`,
        `ap`.`correspondence_language` AS `correspondence_language`,
        `ap`.`alternateMobileNo` AS `alternateMobileNo`,
        `dd`.`name` AS `contactLanguage`,
        `ca`.`itemCode` AS `currentActivitycode`,
        `ca`.`itemValue` AS `currentActivity`,
        `dd`.`name` AS `disabilityIndicator`,
        `ap`.`wheel_chair_required` AS `wheel_chair_required`,
        '' AS `schoolIdentifier`,
        `appl`.`currentStatus` AS `applicationStatus`,
        (CASE
            WHEN (`ap`.`is_tertiary_institution` IS NOT NULL) THEN 'Yes'
            ELSE 'No'
        END) AS `studyTertiaryInst`,
        `ey`.`itemValue` AS `examYear`,
        '' AS `examYearPassedIndicator`,
        '' AS `examYearAverage`,
        MAX((CASE
            WHEN (`ahd`.`sequence` = 1) THEN `res`.`resourceName`
        END)) AS `residenceChoice1`,
        MAX((CASE
            WHEN (`ahd`.`sequence` = 2) THEN `res`.`resourceName`
        END)) AS `residenceChoice2`,
        MAX((CASE
            WHEN (`ahd`.`sequence` = 3) THEN `res`.`resourceName`
        END)) AS `residenceChoice3`,
        `ap`.`firstName` AS `firstname`,
        `ap`.`lastName` AS `lastname`,
        `nat`.`itemValue` AS `nationality`,
        `ap`.`birthDate` AS `birthdate`,
        `ap`.`nationalID` AS `identifier`,
        `idt`.`idTypeCode` AS `idtypecode`,
        `ap`.`identityExpiryDate` AS `identityexpirydate`,
        `post`.`institution_name` AS `Tertiary_Institution_Name`,
        `dd2`.`value` AS `Qualification_Type`,
        `appl`.`applicationCreatedOn` AS `applicationCreatedOn`,
        `appl`.`lastUpdate` AS `lastUpdate`
    FROM
        (((((((((((((((((((`applicant_person` `ap`
        LEFT JOIN `applicant_person_disability` `apd` ON ((`apd`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `drop_down` `dd` ON ((`dd`.`id` = `apd`.`haveDisabilityId`)))
        LEFT JOIN `drop_down` `dd1` ON ((`dd1`.`id` = `ap`.`contact_language`)))
        LEFT JOIN `applicant_education_histories` `aeh` ON ((`aeh`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `examination_year` `ey` ON ((`ey`.`id` = `aeh`.`examYearId`)))
        LEFT JOIN `applicant_hostel_requirement` `ahr` ON ((`ahr`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_hostel_details` `ahd` ON ((`ahd`.`applicantHostelRequirementId` = `ahr`.`id`)))
        LEFT JOIN `hostel` `hostl` ON ((`hostl`.`id` = `ahd`.`hostelId`)))
        LEFT JOIN `resources` `res` ON ((`res`.`id` = `hostl`.`resourceId`)))
        JOIN `application` `appl` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `application_program` `apro` ON ((`apro`.`applicationId` = `appl`.`id`)))
        LEFT JOIN `programs` `prog` ON ((`apro`.`programId` = `prog`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`btc`.`programId` = `prog`.`id`)))
        LEFT JOIN `intake_year` `ir` ON ((`btc`.`intakeYearId` = `ir`.`id`)))
        LEFT JOIN `current_activity` `ca` ON ((`ca`.`id` = `ap`.`current_activity_id`)))
        LEFT JOIN `nationalities` `nat` ON ((`nat`.`id` = `ap`.`nationalityId`)))
        LEFT JOIN `id_type` `idt` ON ((`idt`.`id` = `ap`.`idTypeId`)))
        LEFT JOIN `post_school_studies_section` `post` ON ((`post`.`applicant_person_id` = `ap`.`id`)))
        LEFT JOIN `drop_down` `dd2` ON ((`dd2`.`id` = `post`.`qualificationType`)))
    GROUP BY `appl`.`code`;

END IF; 

END $$
CALL V20210708164417__Create_Applicant_view () $$ 
DROP PROCEDURE IF EXISTS V20210708164417__Create_Applicant_view $$ 
DELIMITER ;