DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708164922__Create_Facultycampus_view $$
CREATE PROCEDURE V20210708164922__Create_Facultycampus_view()
BEGIN

DROP VIEW IF EXISTS facultycampus_view;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='facultycampus_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `facultycampus_view` AS
    SELECT 
        `al`.`academyCode` AS `FacultyCode`,
        `al`.`locationCode` AS `CampusCode`,
        `al`.`academyName` AS `FacultyName`
    FROM
        (((`staffs` `stf`
        JOIN `users` `usr` ON ((`usr`.`id` = `stf`.`userId`)))
        JOIN `user_academy_locations` `ual` ON ((`usr`.`id` = `ual`.`userId`)))
        JOIN `academy_location` `al` ON ((`al`.`id` = `ual`.`academyLocationId`)));

END IF; 

END $$
CALL V20210708164922__Create_Facultycampus_view () $$ 
DROP PROCEDURE IF EXISTS V20210708164922__Create_Facultycampus_view $$ 
DELIMITER ;