DELIMITER $$
DROP PROCEDURE IF EXISTS V20210825132825__Create_PKA_paymentGroup $$
CREATE PROCEDURE V20210825132825__Create_PKA_paymentGroup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_group')) THEN 
CREATE TABLE `payment_group` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(100) NULL,
  `name` VARCHAR(100) NULL,
  `lastUpdatedBy` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `code_UNIQUE` (`code` ASC),
  UNIQUE INDEX `name_UNIQUE` (`name` ASC),
  INDEX `fk_lastUpdateby_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_lastUpdateby`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20210825132825__Create_PKA_paymentGroup () $$ 
DROP PROCEDURE IF EXISTS V20210825132825__Create_PKA_paymentGroup $$ 
DELIMITER ;