DELIMITER $$
DROP PROCEDURE IF EXISTS V20211028143703__Create_ModuleInformation $$
CREATE PROCEDURE V20211028143703__Create_ModuleInformation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='module_information')) THEN 
CREATE TABLE `module_information` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `moduleCode` VARCHAR(100) NOT NULL,
  `moduleName` VARCHAR(100) NOT NULL,
  `isEditable` BIT(1) NOT NULL,
  `portalId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_module_information_portal_idx` (`portalId` ASC),
  INDEX `fk_module_information_users_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_module_information_portal`
    FOREIGN KEY (`portalId`)
    REFERENCES `portals` (`id`),
 CONSTRAINT `fk_module_information__users` 
    FOREIGN KEY (`lastUpdatedBy`) 
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20211028143703__Create_ModuleInformation () $$ 
DROP PROCEDURE IF EXISTS V20211028143703__Create_ModuleInformation $$ 
DELIMITER ;
