DELIMITER $$
DROP PROCEDURE IF EXISTS V20211116151158__Insert_NECBEmployeeIdCard $$
CREATE PROCEDURE V20211116151158__Insert_NECBEmployeeIdCard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'NECB_EMPLOYEE_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'NECB_EMPLOYEE_ID_CARD', 'NECB-Employee Id Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'NECB_EMPLOYEE_ID_CARD.jasper', 'AcademiaLogo.png');

END IF; 

set @NECB_EMPLOYEE_ID_CARD = (select max(id) from report_template where templateCode ='NECB_EMPLOYEE_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='STAFF_ID_CARD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'STAFF_ID_CARD', 'STAFF ID CARD', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='MOBILE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'MOBILE_NO', 'Tell No and Cell', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='RULES_REGULATIONS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'RULES_REGULATIONS', 'Rules and Regulations', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='RULES_TEXT_LINE_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'RULES_TEXT_LINE_ONE', 'First Rules Text', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='RULES_TEXT_LINE_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'RULES_TEXT_LINE_TWO', 'Second Rules Text', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='RULES_TEXT_LINE_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'RULES_TEXT_LINE_THREE', 'Third Rules Text', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='RULES_TEXT_LINE_4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'RULES_TEXT_LINE_4', 'Fourth Rules Text', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='ADDRESS_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'ADDRESS_TEXT', 'Address Value', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='EMAIL_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'EMAIL_TEXT', 'Email And Website', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_EMPLOYEE_ID_CARD and keyValue='VALID_TILL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_EMPLOYEE_ID_CARD, 'VALID_TILL', 'Valid Till' ,'1', NOW());
END IF;


END $$
CALL V20211116151158__Insert_NECBEmployeeIdCard() $$
DROP PROCEDURE IF EXISTS V20211116151158__Insert_NECBEmployeeIdCard $$
DELIMITER ;