DELIMITER $$
DROP PROCEDURE IF EXISTS V20211222140959__Create_analytics_course_wise_view $$
CREATE PROCEDURE V20211222140959__Create_analytics_course_wise_view()
BEGIN
DROP VIEW IF EXISTS analytics_applicant_education_course_wise_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='analytics_applicant_education_course_wise_view')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    SQL SECURITY DEFINER
VIEW `analytics_applicant_education_course_wise_view` AS
    SELECT 
    
        `aeh`.`applicantPersonId` AS `applicantPersonId`,
        `ap`.`externalSysRefOne` AS `sunumber`,
        `app`.`code` AS `application_code`,
        `ap`.`firstName` AS `firstName`,
        `ap`.`lastName` AS `lastName`,
        `ap`.`printName` AS `printName`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 1) THEN MAX(`exam`.`itemValue`)
            WHEN (`aeh`.`examPassedId` = 2) THEN MAX(`exam`.`itemValue`)
            ELSE NULL
        END) AS `Exam_Passed`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 1) THEN `aeh`.`percentage`
            ELSE NULL
        END) AS `Gr_12_Average`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 2) THEN `aeh`.`percentage`
            ELSE NULL
        END) AS `Gr_11_Average`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 1) THEN `aeh`.`examPassedId`
            ELSE NULL
        END) AS `Gr_12_Ave`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 2) THEN `aeh`.`examPassedId`
            ELSE NULL
        END) AS `Gr_11_Ave`,
        `ebm`.`itemValue` AS `Exam_Board`,
        `ed`.`itemValue` AS `Education_Department`,
        `aeh`.`instituteName` AS `instituteName`,
        `cou`.`countryName` AS `countryName`,
        `coureg`.`countryRegionName` AS `countryRegionName`,
        `cty`.`cityName` AS `cityName`,
        `cs`.`itemValue` AS `School`,
        `cs`.`classification` AS `classification`,
        `cs`.`quintile` AS `quintile`,
        `aeh`.`yearOfExam` AS `yearOfExam`,
        `aeh`.`monthOfExamination` AS `monthOfExamination`,
        (CASE
            WHEN (`aeh`.`examPassedId` = 1) THEN MAX(`aeh`.`yearOfExamination`)
            WHEN (`aeh`.`examPassedId` = 2) THEN MAX(`aeh`.`yearOfExamination`)
            ELSE NULL
        END) AS `yearOfExamination`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19331054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19331054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Mathematics`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19321024')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19321024')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Mathematical Literacy`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19351114')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19351114')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Physical Sciences`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19351084')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '19351084')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Life Sciences`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '10351054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '10351054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Agricultural Sciences`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301024')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301024')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Afrikaans Home Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Afrikaans First Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351694')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351694')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Afrikaans Second Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301084')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301084')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `English Home Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311114')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311114')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `English First Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351724')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351724')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `English Second Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301204')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13301204')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `IsiXhosa Home Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311234')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13311234')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `IsiXhosa First Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351784')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '13351784')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `IsiXhosa Second Add Language`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Business Studies`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351084')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351084')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Economics`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '16351054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '16351054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Geography`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351054')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351054')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Design`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351144')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351144')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Visual Arts`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub1`.`itemValue` = 'Physics')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub1`.`itemValue` = 'Physics')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Physics`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub1`.`itemValue` = 'Chemistry')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub1`.`itemValue` = 'Chemistry')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Chemistry`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351084')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351084')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Dramatic Arts`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351114')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '11351114')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Music`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '16351084')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '16351084')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `History`,
        (CASE
            WHEN
                (`aeh`.`examPassedId` = 1)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351024')
                            AND (`aeh`.`examPassedId` = 1))
                    THEN
                        `asmi`.`marks`
                END))
            WHEN
                (`aeh`.`examPassedId` = 2)
            THEN
                MAX((CASE
                    WHEN
                        ((`sub`.`itemCode` = '12351024')
                            AND (`aeh`.`examPassedId` = 2))
                    THEN
                        `asmi`.`marks`
                END))
            ELSE NULL
        END) AS `Accounting`
    FROM
        ((((((((((((((`application_program` `apro`
        LEFT JOIN `application` `app` ON ((`apro`.`applicationId` = `app`.`id`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `app`.`applicantPersonId`)))
        LEFT JOIN `applicant_education_histories` `aeh` ON (((`aeh`.`applicantPersonId` = `ap`.`id`)
            AND (`aeh`.`whetherDeleted` = 0))))
        LEFT JOIN `applicant_subject_mark_info` `asmi` ON ((`aeh`.`id` = `asmi`.`applicantEducationHistoryId`)))
        LEFT JOIN `campaign_school` `cs` ON ((`cs`.`id` = `aeh`.`campaign_school_id`)))
        LEFT JOIN `exam_passed` `exam` ON ((`exam`.`id` = `aeh`.`examPassedId`)))
        LEFT JOIN `subjects` `sub1` ON ((`sub1`.`id` = `asmi`.`subjectId`)))
        LEFT JOIN `exam_board_master` `ebm` ON ((`ebm`.`id` = `aeh`.`examBoardId`)))
        LEFT JOIN `education_department` `ed` ON ((`ed`.`id` = `aeh`.`education_department_id`)))
        LEFT JOIN `country` `cou` ON ((`cou`.`id` = `aeh`.`country_id`)))
        LEFT JOIN `country_region` `coureg` ON ((`coureg`.`id` = `aeh`.`country_region_id`)))
        LEFT JOIN `city` `cty` ON ((`cty`.`id` = `aeh`.`city_id`)))
        LEFT JOIN `nationalities` `nat` ON ((`nat`.`id` = `ap`.`nationalityId`)))
        LEFT JOIN `subjects` `sub` ON ((`sub1`.`equivalentSubjectId` = `sub`.`id`)))
    WHERE
        (`app`.`code` IS NOT NULL)
    GROUP BY `app`.`code` , `aeh`.`examPassedId`;

END IF; 

END $$
CALL V20211222140959__Create_analytics_course_wise_view () $$ 
DROP PROCEDURE IF EXISTS V20211222140959__Create_analytics_course_wise_view $$ 
DELIMITER ;