DELIMITER $$
DROP PROCEDURE IF EXISTS V20220119114306__Insert_BUZZ_HALL_TICKET $$
CREATE PROCEDURE V20220119114306__Insert_BUZZ_HALL_TICKET()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Hall Ticket' );

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'BUZZ_HALL_TICKET')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'BUZZ_HALL_TICKET', 'Buzz Hall Ticket', 'BUZZ_HALL_TICKET.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'BUZZ_HALL_TICKET.jasper', 'AcademiaLogo.png');
END IF; 
 

set @BuzzHallTicket = (select max(id) from report_template where templateCode='BUZZ_HALL_TICKET' and templateName='Buzz Hall Ticket');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_DATE', 'Date', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_EXAMINATION_ADMISSION_CARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_EXAMINATION_ADMISSION_CARD', 'EXAMINATION ADMISSION CARD', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_STUDENT_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_STUDENT_ID', 'Student ID', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_NATIONAL_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_NATIONAL_ID', 'National ID', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_PASSPORT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_PASSPORT', 'Passport', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_ASYLUM_SEEKER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_ASYLUM_SEEKER', 'Asylum Seeker', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_PERMANENT_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_PERMANENT_ID', 'Permanent Residence ID No', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_SEMESTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_SEMESTER', 'Semester', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_MODULE_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_MODULE_CODE', 'Module Code', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_MODULE_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_MODULE_NAME', 'Module Name', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_EXAM_GROUP') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_EXAM_GROUP', 'Exam Group', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_EXAM_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_EXAM_DATE', 'Exam Date', NOW());
END IF;	

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_START_TIME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_START_TIME', 'Start Time', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_EXAMINATION_CENTRE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_EXAMINATION_CENTRE', 'Examination Centre', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_ADDRESS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_ADDRESS', 'Address', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_ASSESSMENT_OFFICER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_ASSESSMENT_OFFICER', 'ASSESSMENT OFFICER', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @BuzzHallTicket AND keyValue='TRANS_NOTE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@BuzzHallTicket, 'TRANS_NOTE', 'PLEASE NOTE THE FOLLOWING', NOW());
END IF;



END $$
CALL V20220119114306__Insert_BUZZ_HALL_TICKET() $$
DROP PROCEDURE IF EXISTS V20220119114306__Insert_BUZZ_HALL_TICKET $$
DELIMITER ;