DELIMITER $$
DROP PROCEDURE IF EXISTS V20220718125032__Create_examDaysToSKip $$
CREATE PROCEDURE V20220718125032__Create_examDaysToSKip()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='eval_group_days_to_skip' )) THEN 
CREATE TABLE `eval_group_days_to_skip` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `evaluationGroupId` BIGINT NOT NULL,
  `weekday` VARCHAR(100) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `evalGroup_lastUpdateBy` (`lastUpdatedBy` ASC) ,
  INDEX `evalGroup_EvaluationGroup` (`evaluationGroupId` ASC) ,
  CONSTRAINT `evalGroup_c_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
CONSTRAINT `evalGroup_c_EvaluationGroup`
	FOREIGN KEY (`evaluationGroupId`)
	REFERENCES `evaluation_group` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20220718125032__Create_examDaysToSKip () $$ 
DROP PROCEDURE IF EXISTS V20220718125032__Create_examDaysToSKip $$ 
DELIMITER ;