DELIMITER $$
DROP PROCEDURE IF EXISTS V20220722123536__Create_PeriodDetailsPeriodStatus $$
CREATE PROCEDURE V20220722123536__Create_PeriodDetailsPeriodStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='period_details_period_status')) THEN

CREATE TABLE `period_details_period_status` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `periodStatusId` BIGINT(20) NOT NULL,
  `programBatchPeriodConfigurationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicant_person_interventions_idx` (`periodStatusId` ASC),
  INDEX `fk_applicant_person_Id_idx` (`programBatchPeriodConfigurationId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_period_details_Period_status_id`
    FOREIGN KEY (`periodStatusId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_details_Period_status_programbatchperiodid`
    FOREIGN KEY (`programBatchPeriodConfigurationId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_details_Period_status_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20220722123536__Create_PeriodDetailsPeriodStatus () $$ 
DROP PROCEDURE IF EXISTS V20220722123536__Create_PeriodDetailsPeriodStatus $$ 
DELIMITER ;