DELIMITER $$
DROP PROCEDURE IF EXISTS V20220901102018__Create_ApplicationAdmissionCommentTable $$
CREATE PROCEDURE V20220901102018__Create_ApplicationAdmissionCommentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_admission_comments')) THEN 
CREATE TABLE IF NOT EXISTS `application_admission_comments` (
	 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `applicationId` BIGINT(20) NOT NULL,
  `reassignUserId` BIGINT(20) NOT NULL,
   `assignbyUserId` BIGINT(20) NULL DEFAULT NULL,
  `commentText` VARCHAR(255) NOT NULL,
  `reassignDate` DATE NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `application_admission_comments_fk_1_idx` (`applicationId` ASC),
  INDEX `application_admission_comments_fk_2_idx` (`reassignUserId` ASC),
  INDEX `application_admission_comments_fk_3_idx` (`lastUpdatedBy` ASC),
  INDEX `application_admission_comments_fk_4_idx` (`assignbyUserId` ASC),
  CONSTRAINT `application_admission_comments_fk_1`
    FOREIGN KEY (`applicationId`)
    REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
     FOREIGN KEY (`assignbyUserId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
   FOREIGN KEY (`reassignUserId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
 
END IF; 

END $$
CALL V20220901102018__Create_ApplicationAdmissionCommentTable () $$ 
DROP PROCEDURE IF EXISTS V20220901102018__Create_ApplicationAdmissionCommentTable $$ 
DELIMITER ;