DELIMITER $$
DROP PROCEDURE IF EXISTS V20220922202958__Create_ScholarshipOwnersTable $$
CREATE PROCEDURE V20220922202958__Create_ScholarshipOwnersTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_owners')) THEN 
CREATE TABLE `scholarship_owners` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `ownerId` BIGINT(20) NOT NULL,
  `scholarshipId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_scholarship_owners_ownerId` FOREIGN KEY (`ownerId`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_scholarship_owners_scholarshipId` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship` (`id`),
  CONSTRAINT `fk_scholarship_owners_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20220922202958__Create_ScholarshipOwnersTable () $$ 
DROP PROCEDURE IF EXISTS V20220922202958__Create_ScholarshipOwnersTable $$ 
DELIMITER ;