-- SUBMIT_APPLICATION_COURSE_COORDINATOR ( uwc client)

DELIMITER $$
DROP PROCEDURE IF EXISTS V20221006104925__Create_submitAppCourseCoordinatorEvent $$
CREATE PROCEDURE V20221006104925__Create_submitAppCourseCoordinatorEvent()
BEGIN
IF NOT EXISTS ((SELECT id FROM system_msg_event where code='SUBMIT_APPLICATION_COURSE_COORDINATOR' )) THEN 

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SUBMIT_APPLICATION_COURSE_COORDINATOR');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SUBMIT_APPLICATION_COURSE_COORDINATOR');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SUBMIT_APPLICATION_COURSE_COORDINATOR', 'Submit Application Course Coordinator', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Submit Application Course Coordinator');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SUBMIT_APPLICATION_COURSE_COORDINATOR_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_COURSE_COORDINATOR_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_COURSE_COORDINATOR_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `application` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
     T1.`id` AS ID,    
     T4.`firstName` AS FIRST_NAME,
     T4.`lastName` AS LAST_NAME,   
	 T4.`printName` AS PRINT_NAME,
     T1.`code` AS APPLICATION_CODE,
     T4.`emailId` AS EMAIL_ID,
	 T3.`programName` as PROGRAM_NAME,
	 T6.`printName` as BATCH_NAME,
	 T7.`seatName` as SEAT_TYPE_NAME,
	 T8.`displayName` as ACADEMY_LOCATION,
	 T9.`academyName` as ACADEMY,
	 T10.printName as PERIOD,
     T11.firstName as APP_FIRST_NAME,
     T11.middleName as APP_MIDDLE_NAME,
     T11.lastName as APP_LAST_NAME,
     T11.printName as APPLICANT_PRINT_NAME,
	 (CASE
         WHEN
             T8.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T8.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (CASE
         WHEN
             T8.footerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T8.footerUrl)
         ELSE NULL
     END) AS FOOTER_URL,
     (CASE
         WHEN
             T8.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T8.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
     END) AS LOGO_URL
	 
 FROM
    application as T1 
	left join application_program as T2 on T1.id=T2.applicationId
	left join programs as T3 on T3.id=T2.programId
	left join users as T4 on T3.approver=T4.id
    left join prog_batch_seat_config as T5 on T5.id=T2.progBatchSeatConfigId
	left join batches as T6 on T6.id=T5.programBatchId
	left join seat_types as T7 on T7.id=T5.seatTypeId
	left join academy_location as T8 on T8.id=T2.academyLocationId
	left join academies as T9 on T9.id=T8.academyId
	left join prog_batch_period_config as T10 on T10.programBatchId=T6.id
    left join organizations org ON org.id = (SELECT MAX(id) FROM organizations)
    left join applicant_person as T11 ON T1.applicantPersonId=T11.id
 WHERE
     T1.id IN (namedParams) limit 1",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 2
        },{
            "id": 4,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 3
        },
	{
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
	{
            "id": 6,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
	{
            "id": 7,
            "value": "printName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
	{
            "id": 8,
            "value": "seatName",
            "resultKey": "SEAT_TYPE_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
	{
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
	{
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY",
            "displayCode": "",
            "displayOrder": 9
        },
	{
            "id": 11,
            "value": "printName",
            "resultKey": "PERIOD",
            "displayCode": "",
            "displayOrder": 10
        },
	{
             "id": 12,
             "value": "logoUrl",
             "resultKey": "LOGO_URL",
             "displayCode": "",
             "displayOrder": 11
         },
 	{
             "id": 13,
             "value": "headerUrl",
             "resultKey": "HEADER_URL",
             "displayCode": "",
             "displayOrder": 12
         },
 	{
             "id": 14,
             "value": "footerUrl",
             "resultKey": "FOOTER_URL",
             "displayCode": "",
             "displayOrder": 13
         },
 	{
             "id": 15,
             "value": "firstName",
             "resultKey": "APP_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 14
         },
 	{
             "id": 16,
             "value": "middleName",
             "resultKey": "APP_MIDDLE_NAME",
             "displayCode": "",
             "displayOrder": 15
         },
 	{
             "id": 17,
             "value": "lastName",
             "resultKey": "APP_LAST_NAME",
             "displayCode": "",
             "displayOrder": 16
         },
 	{
             "id": 18,
             "value": "printName",
             "resultKey": "APPLICANT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 17
         }
]}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SUBMIT_APPLICATION_COURSE_COORDINATOR');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SUBMIT_APPLICATION_COURSE_COORDINATOR');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Submit Application Course Coordinator Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Submit Application Course Coordinator Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application submitted','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0;">
			<td align="center" style="margin:0px; padding:0px;"><img height="150" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="padding:0px 0px 0px 20px;">The Applicant $recipientData[&quot;APPLICATION_CODE&quot;] has been assigned to you For $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;]</span><br /></p>
			<p style="padding:0px 0px 0px 20px;">Regards,
			<br/>
			<strong>$recipientData[&quot;ACADEMY_LOCATION&quot;]</strong><br/>
			</p>
			</td>
		</tr>
		<tr><td align="center" style="margin:0px; padding:0px; background-color:#f0f0f0;"><img height="100" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td></tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Application submitted','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0;">
			<td align="center" style="margin:0px; padding:0px;"><img height="150" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="padding:0px 0px 0px 20px;">The Applicant $recipientData[&quot;APPLICATION_CODE&quot;] has been assigned to you For $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;]</span><br /></p>
			<p style="padding:0px 0px 0px 20px;">Regards,
			<br/>
			<strong>$recipientData[&quot;ACADEMY_LOCATION&quot;]</strong><br/>
			</p>
			</td>
		</tr>
		<tr><td align="center" style="margin:0px; padding:0px; background-color:#f0f0f0;"><img height="100" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td></tr>
	</tbody>
</table>
</body>
</html>');
END IF; 
END $$
CALL V20221006104925__Create_submitAppCourseCoordinatorEvent () $$ 
DROP PROCEDURE IF EXISTS V20221006104925__Create_submitAppCourseCoordinatorEvent $$ 
DELIMITER ;
