DELIMITER $$
DROP PROCEDURE IF EXISTS V20221007172812__Create_ExaminersReportTable $$
CREATE PROCEDURE V20221007172812__Create_ExaminersReportTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='examiners_report')) THEN 
CREATE TABLE `examiners_report`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint NOT NULL,
`functionaryID` BIGINT(20) NOT NULL,
`name` VARCHAR(255) NOT NULL,
`lastName` VARCHAR(255) NULL DEFAULT NULL,
`functionaryType` bigint(20) NOT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_examinersReport_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_examinersReport_SU_functionaryType` FOREIGN KEY (`functionaryType`) REFERENCES `functionary_type` (`id`),
CONSTRAINT `FK_examinersReport_SU_functionaryID` FOREIGN KEY (`functionaryID`) REFERENCES `users` (`id`),
CONSTRAINT `FK_examinersReport_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_examinersReport_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20221007172812__Create_ExaminersReportTable () $$ 
DROP PROCEDURE IF EXISTS V20221007172812__Create_ExaminersReportTable $$ 
DELIMITER ;