DELIMITER $$
DROP PROCEDURE IF EXISTS V20221118144157__Create_CreateStudentJourney $$
CREATE PROCEDURE V20221118144157__Create_CreateStudentJourney()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey')) THEN

CREATE TABLE `student_journey` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `programId` bigint(20) NOT NULL,
  `programBatchId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `academyCampusId` BIGINT NULL DEFAULT NULL,
  `academicTermId` BIGINT NULL DEFAULT NULL,
  `admissionId` bigint DEFAULT NULL,
  `studentId` bigint DEFAULT NULL,
  `periodStatus` varchar(255) DEFAULT NULL,
  `resultStatus` varchar(255) DEFAULT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_academyLocation_Id_idx` (`academyLocationId` ASC),
  INDEX `fk_program_Id_idx` (`programId` ASC),
  INDEX `fk_program_Batch_Id_idx` (`programBatchId` ASC),
  INDEX `fk_academyCampus_Id_idx` (`academyCampusId` ASC),
  INDEX `fk_academicTerm_Id_idx` (`academicTermId` ASC),
  INDEX `fk_student_Id_idx` (`studentId` ASC),
  INDEX `fk_period_Id_idx` (`periodId` ASC),
  INDEX `fk_admision_Id_idx` (`admissionId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),

  CONSTRAINT `fk_sj_programId` 
	FOREIGN KEY (`programId`)
	REFERENCES `programs` (`id`),
  CONSTRAINT `fk_sj_programBatchId` 
	FOREIGN KEY (`programBatchId`) 
	REFERENCES `batches` (`id`) ,
  CONSTRAINT `fk_sj_academicTermId` 
	FOREIGN KEY (`academicTermId`) 
	REFERENCES `academic_term` (`id`) ,
 CONSTRAINT `fk_sj_academyLocationId` 
	FOREIGN KEY (`academyLocationId`) 
	REFERENCES `academy_location` (`id`) ,
  CONSTRAINT `fk_sj_periodId` 
	FOREIGN KEY (`periodId`) 
	REFERENCES `prog_batch_period_config` (`id`) ,
  CONSTRAINT `fk_sj_academyCampusId` 
	FOREIGN KEY (`academyCampusId`) 
	REFERENCES `academy_location_campus` (`id`) ,
   CONSTRAINT fk_sj_studentId
   FOREIGN KEY (studentId)
   REFERENCES students (userId),
  CONSTRAINT `fk_sj_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`),
  CONSTRAINT `fk_sj_admissionId`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
END IF;

END $$
CALL V20221118144157__Create_CreateStudentJourney () $$ 
DROP PROCEDURE IF EXISTS V20221118144157__Create_CreateStudentJourney $$ 
DELIMITER ;