DELIMITER $$
DROP PROCEDURE IF EXISTS V20221214121636__Create_AdmissionEnquiryCoursesTable $$
CREATE PROCEDURE V20221214121636__Create_AdmissionEnquiryCoursesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_enquiry_courses')) THEN 
CREATE TABLE `admission_enquiry_courses`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT(20) NOT NULL,
  `admissionEnquiryDetailId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `admission_enquiry_courses_courseId_FK` FOREIGN KEY (`courseId`) REFERENCES `courses`(`id`),
  CONSTRAINT `admission_enquiry_courses_admissionEnquiryDetailId_FK` FOREIGN KEY (`admissionEnquiryDetailId`) REFERENCES `admission_enq_details`(`id`),
  CONSTRAINT `admission_enquiry_courses_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20221214121636__Create_AdmissionEnquiryCoursesTable () $$ 
DROP PROCEDURE IF EXISTS V20221214121636__Create_AdmissionEnquiryCoursesTable $$ 
DELIMITER ;