DELIMITER $$
DROP PROCEDURE IF EXISTS V20230212201153__Alter_AddColInFunctionaryDetail $$
CREATE PROCEDURE V20230212201153__Alter_AddColInFunctionaryDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='person_functionary_details' AND column_name='oUDepartment')) THEN 
ALTER TABLE `person_functionary_details`

ADD COLUMN `oUDepartment` bigint(20) DEFAULT NULL AFTER `functionaryInvolvementInPercentage`, 
ADD CONSTRAINT `FK_personFunctionaryDetails_SU_oUDepartment` FOREIGN KEY (`oUDepartment`) REFERENCES `ou_department` (`id`);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='person_functionary_details' AND column_name='functionaryDepartment')) THEN 
ALTER TABLE `person_functionary_details`

ADD COLUMN `functionaryDepartment` VARCHAR(255) DEFAULT NULL AFTER `oUDepartment`;
END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='OU_DEPARTMENT' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','OU_DEPARTMENT','Functionary OU Department','Functionary OUD epartment',
'Funksionele OU-afdeling','Phòng chức năng OU',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='FUNCTIONARY_DEPARTMENT' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','FUNCTIONARY_DEPARTMENT','Functionary Department','Functionary Department',
'Funksionele Departement','Vụ chức năng',now(),1);
END IF; 

END $$
CALL V20230212201153__Alter_AddColInFunctionaryDetail() $$
DROP PROCEDURE IF EXISTS V20230212201153__Alter_AddColInFunctionaryDetail $$
DELIMITER ;