DELIMITER $$
DROP PROCEDURE IF EXISTS V20230329014642__Create_business_rule_conditions $$
CREATE PROCEDURE V20230329014642__Create_business_rule_conditions()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_conditions')) THEN 
CREATE TABLE `business_rule_conditions` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `evaluationPlanType` VARCHAR(255) NULL,
  `evaluationPlanId` BIGINT NULL,
  `businessRuleId` BIGINT NOT NULL,
  `businessAttributeRuleId` BIGINT NOT NULL,
  `businessRuleConditionsAttributeId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_BRC_evaluationPlanId_idx` (`evaluationPlanId` ASC),
  INDEX `fk_BRC_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_BRC_businessRuleId_idx` (`businessRuleId` ASC),
  INDEX `fk_BRC_businessRuleConditionsAttributeId_idx` (`businessRuleConditionsAttributeId` ASC),
  CONSTRAINT `fk_business_rule_conditions_evaluationPlanId`
    FOREIGN KEY (`evaluationPlanId`)
    REFERENCES `evaluation_plan` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
		
    CONSTRAINT `fk_business_rule_conditions_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,

    CONSTRAINT `fk_business_rule_conditions_businessRuleId`
    FOREIGN KEY (`businessRuleId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_business_rule_conditions_businessAttributeRuleId`
    FOREIGN KEY (`businessAttributeRuleId`)
    REFERENCES `business_attribute_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,

    CONSTRAINT `fk_business_rule_conditions_businessRuleConditionsAttributeId`
    FOREIGN KEY (`businessRuleConditionsAttributeId`)
    REFERENCES `business_rule_conditions_attribute` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20230329014642__Create_business_rule_conditions () $$ 
DROP PROCEDURE IF EXISTS V20230329014642__Create_business_rule_conditions $$ 
DELIMITER ;