DELIMITER $$
DROP PROCEDURE IF EXISTS V20230329194836__Update_PostgraduateManaStudDataprovider $$
CREATE PROCEDURE V20230329194836__Update_PostgraduateManaStudDataprovider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'POST_GRADUATE_MANAGEMENT_STUDENTS_INFO')) THEN 
UPDATE dydt_data_line_item
SET whereClauseBindingDef = 'PRM_ADMISSION_ID', sqlSelectQueryDef= "SELECT 
T4.id AS id,
T4.firstName AS student_first_name,
T4.middleName AS student_middle_name,
T4.lastName AS student_last_name,
T1.code as student_id,
T4.externalSysRefOne AS student_su_number,
T4.mobileNumber AS Student_mobile_no,
T4.emailId AS student_email_id,
T9.itemValue AS Year,
T5.programName AS program_name,
T5.fieldOfStudyLanguageTwo AS filed_of_study,
T6.doctoral_thesis AS dissertation_or_thesis_title,
T7.deptName AS supervisor_department
from admission T3
left join users T1 on T1.id=T3.studentId
left join students T2 on T2.userId=T1.id
left join  persons T4 on T4.id=T2.personId
left join programs T5 on T5.id=T3.programId
left join batches T8 on T8.id =T3.batchId
left join intake_year T9 on T9.id= T8.intakeYearId
left join post_school_studies_section T6 on T6.persons_id=T2.personId
left join department T7 on T7.id=T5.programDepartmentId"
,sqlWhereQueryDef="WHERE T3.id = PRM_ADMISSION_ID  order by T6.id desc limit 1;"
WHERE dataSourceCode = 'POST_GRADUATE_MANAGEMENT_STUDENTS_INFO';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230329194836__Update_PostgraduateManaStudDataprovider () $$
DROP PROCEDURE IF EXISTS V20230329194836__Update_PostgraduateManaStudDataprovider $$
DELIMITER ;