DELIMITER $$
DROP PROCEDURE IF EXISTS V20230420185553__Update_CreateEnquiryVelocityReciUpdate $$
CREATE PROCEDURE V20230420185553__Update_CreateEnquiryVelocityReciUpdate()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS')) THEN 
SET @enqVelRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS');
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRST_NAME,
    T1.lastName AS PARENT_LAST_NAME,
    T2.studentFirstName AS FIRST_NAME,
    T2.studentLastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
	T4.academyid AS ACADEMY_ID,
	T4.locationid AS LOCATION_ID,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL    
FROM
    enquiry T1
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    admission_enq_details T3 ON T3.enqStudentDetailsId = T2.id
        LEFT JOIN
    academy_location T4 ON T4.id = T3.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "locationId",
            "resultKey": "LOCATION_ID",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' WHERE (`dataProviderId` = @enqVelRecId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230420185553__Update_CreateEnquiryVelocityReciUpdate () $$
DROP PROCEDURE IF EXISTS V20230420185553__Update_CreateEnquiryVelocityReciUpdate $$
DELIMITER ;