DELIMITER $$
DROP PROCEDURE IF EXISTS `rpt_Application_Summary`$$ 
CREATE PROCEDURE `rpt_Application_Summary`(academyLocation TEXT,
 intakeYear INT(10), StartDate DATE, EndDate DATE, ProgramCategory INT(10), ProgramGroup INT(10), 
 seatType TEXT)
BEGIN

declare StartDateNull boolean default if(StartDate is null,1,0);
declare EndDateNull boolean default if(EndDate is null,1,0);
declare ProgramCategoryNull boolean default if(ProgramCategory is null,1,0);
declare ProgramGroupNull boolean default if(ProgramGroup is null,1,0);
declare SeatTypeNull boolean default if(seatType is null or seatType='',1,0);

	DECLARE cur_Brand_Campus VARCHAR(250);
    
	DECLARE cur_Brand_Campus_ID, cur_alId, cur_Application_ID, 
    cur_programid,cur_Total_SUCCESSFUL_Admission,cur_Total_Application,cur_Total_UNSuccessful,
    cur_Total_Enq, cur_app_this_week,cur_YOY_Variance_Total_Approve_Application_target,
    cur_Total_SUCCESSFUL_Admission_prev, cur_target_for_Total_success_approve_app,cur_programSequence,
    cur_Total_sucessful_wrt_lead, cur_Total_Interviews,
    cur_total_converted_enq, cur_seattypeid INT;
 
    DECLARE cur_grade VARCHAR(500);
    DECLARE cur_convert_perc_lead, cur_Perc_Target_Total_Success_Approve_App DOUBLE DEFAULT 0;

    declare no_more_rows boolean default false;

call str_to_row (academyLocation);
call str_to_row_seattype (seatType);
    
drop table if exists tbl_rpt_Application_Summary;
create table tbl_rpt_Application_Summary(Brand_Campus varchar(250), Brand_Campus_ID int, programId int, grade varchar(500), Total_SUCCESSFUL_Admission int default 0, 
Total_UNSuccessful int default 0, Total_Enq int default 0, convert_perc_lead double default 0, Weekly_movement_Tot_Success_Approve_Apps int default 0, 
Target_total_success_approv_apps int default 0, Perc_Target_Total_Success_Approve_App double default 0, YOY_Variance_Total_Approve_Application_target int default 0,
Total_SUCCESSFUL_Admission_prev int default 0, total_converted_enq int default 0, Total_Application int default 0, Total_Interviews int default 0,programSequence int default 0);



START TRANSACTION;
BLOCK1: begin
DECLARE cur CURSOR FOR

select concat(al.academyName, '-', al.locationName) as brd_campus, al.id, program.id, 
program.programNameToBePrint,program.programSequence,
seatConfig.seattypeid
from prog_batch_seat_config as seatConfig
join batches as batch on seatConfig.programBatchId = batch.id
join programs as program on batch.programId = program.id and program.status = 'O' 
and program.programClosureDate is null
join academy_location as al on program.academyLocationId = al.id
where 
al.id in (select s from tbl_str_to_row) and batch.intakeYearId = intakeYear
and (program.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (program.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (seatConfig.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, program.id ;

declare continue handler for not found  set no_more_rows := true;

OPEN cur;

 read_loop: LOOP

FETCH cur INTO cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_programSequence, cur_seattypeid;

if no_more_rows then set no_more_rows := false;
        close cur;
        leave read_loop;
end if;    


set cur_Total_SUCCESSFUL_Admission:= (select count(distinct a.code) as Total_SUCCESSFUL_Admission
from application a 
join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.applicationCreationSource is not null
and a.currentStatus in ('APPLIED','NOT_APPLIED','SOLD','APPROVED','INCOMPLETE','CLOSED','DIRECT_ADMISSION','MID_TERM_ADMISSION','FORM_SALE_TOKEN_GENERATED','NOT_SUBMITTED','ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and al.id = cur_alId and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id);  

if no_more_rows then set cur_Total_SUCCESSFUL_Admission=0; set no_more_rows=false; end if;


set cur_Total_Application:=(select count(distinct a.code) as Total_Application
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.currentStatus in ('SUBMITTED','REJECTED', 'WITHDRAWN', 'APPROVED', 'ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and al.id = cur_alId and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id);
if no_more_rows then set cur_Total_Application=0; set no_more_rows=false; end if;

 
set cur_Total_Interviews:=(select count(distinct a.code) as Total_Interviews
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join program_selection_process as psp on psp.programBatchSeatConfigId = absc.id
join program_slctn_process_stages as ps on psp.id = ps.programSelectionProcessId and ps.currentStatus = 'INPROGRESS'
join application_prog_stage as aps on aps.applicationProgramId = ap.id and aps.currentStatus = 'INPROGRESS'
where(date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and al.id = cur_alId and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id);
if no_more_rows then set cur_Total_Interviews=0; set no_more_rows=false; end if;


set cur_Total_UNSuccessful:=(select count(distinct a.id) as Total_UNSuccessful
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.currentStatus in ('REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and cur_alId =al.id and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id);
if no_more_rows then set cur_Total_UNSuccessful=0; set no_more_rows=false; end if;

set cur_Total_Enq:=(select count(distinct e.id) as Total_Enq
from admission_enq_details as aed
join enq_student_details esd on aed.enqStudentDetailsId = esd.id
join prog_batch_seat_config absc on aed.progBatchSeatConfigId=absc.id 
join seat_types st on st.id = absc.seatTypeId
join batches b on b.id = aed.batchId and b.intakeYearId = intakeYear
join intake_year iy on iy.id = b.intakeYearId
join programs as p on b.programId=p.id and aed.programId=p.id and p.status = 'O'
join academy_location as al on p.academyLocationId=al.id and aed.academyLocationId=al.id
join enquiry as e on esd.enquiryId=e.id and e.academyLocationId=al.id
where (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and al.id = cur_alId and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by e.academyLocationId, aed.programId);
 if no_more_rows then set cur_Total_Enq=0; set no_more_rows=false; end if;

 set cur_app_this_week:=(select count(distinct a.code) as app_this_week
from application a join application_program ap on a.id=ap.applicationId
join academy_location al on al.id = ap.academyLocationId 
join academy_location_purpose alp on al.id = alp.academyLocationId
join calendars on alp.calendarId = calendars.id
join programs p on p.id = ap.programId and p.status = 'O'
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.applicationCreatedOn between (date_sub(current_date(), interval WEEKDAY(current_date()) -
(case when weekStart = 'MONDAY' then 0
when weekStart = 'TUESDAY' then 1
when weekStart = 'WEDNESDAY' then 2
when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4
when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and a.applicationCreationSource is not null
and a.currentStatus in ('APPLIED','NOT_APPLIED','SOLD','APPROVED','INCOMPLETE','CLOSED','DIRECT_ADMISSION','MID_TERM_ADMISSION','FORM_SALE_TOKEN_GENERATED','NOT_SUBMITTED','ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and al.id = cur_alId and p.id = cur_programid
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, ap.programId);
if no_more_rows then set cur_app_this_week=0; set no_more_rows=false; end if;

 
set cur_target_for_Total_success_approve_app:=(select ifnull(applicationTarget,0)
from manage_target as mt 
join programs as p on p.id = mt.programId
join batches as b on b.programId = p.id and b.intakeYearId = intakeYear
where mt.intakeYearId = intakeYear
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
and ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and mt.academyLocationId = cur_alId and p.id = cur_programid
group by mt.academyLocationId,p.id);
if no_more_rows then set cur_target_for_Total_success_approve_app=0; set no_more_rows=false; end if;


set cur_Perc_Target_Total_Success_Approve_App:=(select ifnull(cur_Total_SUCCESSFUL_Admission / NULLIF(cur_target_for_Total_success_approve_app,0) * 100,0) 
as Perc_Target_Total_Success_Approve_App);



Select ifnull((count(distinct a.id)/ cur_Total_Enq) * 100,0), ifnull(count(distinct a.id),0) into cur_convert_perc_lead, cur_total_converted_enq
from application a 
join application_program ap on a.id=ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.saleRefId is not null
and al.id = cur_alId and p.id = cur_programid
group by al.id, p.id;
if no_more_rows then set cur_convert_perc_lead=0; set cur_total_converted_enq =0; set no_more_rows=false; end if;


select ifnull(((curr_intake.Total_SUCCESSFUL_Admission - prev_intake.Total_SUCCESSFUL_Admission)/NULLIF(prev_intake.Total_SUCCESSFUL_Admission,0) * 100),0), prev_intake.Total_SUCCESSFUL_Admission into cur_YOY_Variance_Total_Approve_Application_target, cur_Total_SUCCESSFUL_Admission_prev
from 
(Select count(distinct a.code) as Total_SUCCESSFUL_Admission, p.id as programId, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId 
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id 
join batches as b on b.id = pb.programBatchId and b.intakeYearId = intakeYear
where
a.applicationCreationSource is not null and
a.currentStatus in ('APPLIED','NOT_APPLIED','SOLD','APPROVED','INCOMPLETE','CLOSED','DIRECT_ADMISSION','MID_TERM_ADMISSION','FORM_SALE_TOKEN_GENERATED','NOT_SUBMITTED','ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and cur_alId =al.id and p.id = cur_programid
and (pb.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as curr_intake
left join
(Select count(distinct a.id) as Total_SUCCESSFUL_Admission, p.id as programId, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId 
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id 
join batches as b on b.id = pb.programBatchId and b.intakeYearId = (select id from intake_year
where itemValue = (select itemValue - 1 from intake_year where id = intakeYear))
where
a.applicationCreationSource is not null and
a.currentStatus in ('APPLIED','NOT_APPLIED','SOLD','APPROVED','INCOMPLETE','CLOSED','DIRECT_ADMISSION','MID_TERM_ADMISSION','FORM_SALE_TOKEN_GENERATED','NOT_SUBMITTED','ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and cur_alId =al.id and p.id = cur_programid
and (pb.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as prev_intake
on prev_intake.alId = curr_intake.alId and prev_intake.programId = curr_intake.programId;
if no_more_rows then set cur_YOY_Variance_Total_Approve_Application_target=0; set cur_Total_SUCCESSFUL_Admission_prev =0; set no_more_rows=false; end if;


INSERT INTO tbl_rpt_Application_Summary
VALUES(cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_Total_SUCCESSFUL_Admission,cur_Total_UNSuccessful,cur_Total_Enq,
cur_convert_perc_lead,cur_app_this_week,cur_target_for_Total_success_approve_app,cur_Perc_Target_Total_Success_Approve_App,
cur_YOY_Variance_Total_Approve_Application_target,cur_Total_SUCCESSFUL_Admission_prev,cur_total_converted_enq,cur_Total_Application,cur_Total_Interviews,cur_programSequence);
       
   
END loop read_loop;
-- CLOSE cur; 
END BLOCK1;
commit;

 select Brand_Campus, grade, Total_SUCCESSFUL_Admission, Total_UNSuccessful,
 convert_perc_lead, Weekly_movement_Tot_Success_Approve_Apps, Target_total_success_approv_apps,
Perc_Target_Total_Success_Approve_App, YOY_Variance_Total_Approve_Application_target, total_enq,
Total_SUCCESSFUL_Admission_prev, total_converted_enq, Total_Application, Total_Interviews,programSequence
from tbl_rpt_Application_Summary order by Brand_Campus,programSequence;

END$$
DELIMITER ;