DELIMITER $$
DROP PROCEDURE IF EXISTS V20230705182426__Create_ApplicantVisaDocumentTable $$
CREATE PROCEDURE V20230705182426__Create_ApplicantVisaDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_visa_document')) THEN 
CREATE TABLE `applicant_visa_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `applicantVisaId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `applicant_visa_document_FK` FOREIGN KEY (`applicantVisaId`) REFERENCES applicant_visa_details(`id`),
  CONSTRAINT `applicant_visa_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `applicant_visa_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20230705182426__Create_ApplicantVisaDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20230705182426__Create_ApplicantVisaDocumentTable $$ 
DELIMITER ;