DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726105941__Insert_dfr_HealthInsuranceProgTransfer $$
CREATE PROCEDURE V20230726105941__Insert_dfr_HealthInsuranceProgTransfer()
BEGIN

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'programrequestdetailspanel' and  `formFieldId`='authorizeDeclarationId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('programrequestdetailspanel','authorizeDeclaration','authorizeDeclarationId','checkbox',0,0,NULL,1,now(),'I do not authorise the school to contact my parent/sponsor and I prefers to contact them directly without the intervention of the school representative(s).','','Program Transfer Request','Create','I do not authorise the school to contact my parent/sponsor and I prefers to contact them directly without the intervention of the school representative(s).',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'programrequestdetailspanel' and  `formFieldId`='healthInsuranceId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('programrequestdetailspanel','healthInsurance','healthInsuranceId','fieldcontainer',0,0,NULL,1,now(),'Health Insurance','','Program Transfer Request','Create','Health Insurance',0);
END IF; 


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'programrequestdetailspanel' and  `formFieldId`='scholarshipId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('programrequestdetailspanel','scholarship','scholarshipId','fieldcontainer',0,0,NULL,1,now(),'Scholarship','','Program Transfer Request','Create','Scholarship',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'programrequestdetailspanel' and  `formFieldId`='medicalIssuesId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('programrequestdetailspanel','medicalIssues','medicalIssuesId','fieldcontainer',0,0,NULL,1,now(),'Medical Issues or Learning Differences','','Program Transfer Request','Create','Medical Issues or Learning Differences',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'programrequestdetailspanel' and  `formFieldId`='upToDateDetailsId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('programrequestdetailspanel','upToDateDetails','upToDateDetailsId','checkbox',0,0,NULL,1,now(),'Please tick here to confirm your details are up to date','','Program Transfer Request','Create','Please tick here to confirm your details are up to date',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PT_AUTHORIZED_DECLARATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PT_AUTHORIZED_DECLARATION', 'Please ensure that your parent/sponsor are aware of your situation and that their contact details are up to date (insert a hyperlink to Student Profile here) If you do not authorise the school to contact your parent/sponsor via any means available, with full details regarding your situation, please tick the following checkbox.', 'Please ensure that your parent/sponsor are aware of your situation and that their contact details are up to date (insert a hyperlink to Student Profile here) If you do not authorise the school to contact your parent/sponsor via any means available, with full details regarding your situation, please tick the following checkbox.','Maak asseblief seker dat u ouer/borg bewus is van u situasie en dat hul kontakbesonderhede op datum is (voeg n hiperskakel na Studenteprofiel hier in) Indien u nie die skool magtig om u ouer/borg op enige beskikbare wyse te kontak nie, met volledige besonderhede rakende jou situasie, merk asseblief die volgende merkblokkie.','Vui lòng đảm bảo rằng phụ huynh/người bảo trợ của bạn biết về hoàn cảnh của bạn và thông tin liên lạc của họ được cập nhật (chèn một siêu liên kết đến Hồ sơ Học sinh tại đây) Nếu bạn không cho phép nhà trường liên hệ với phụ huynh/người bảo trợ của mình qua bất kỳ phương tiện nào có sẵn, với đầy đủ thông tin chi tiết về hoàn cảnh của bạn, vui lòng đánh dấu vào hộp kiểm sau.',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PT_HEALTH_INSURANCE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PT_HEALTH_INSURANCE', 'Please tick here if you require to register for the School Health Insurance', 'Please tick here if you require to register for the School Health Insurance','Merk asseblief hier as jy vir die Skoolgesondheidsversekering wil registreer','Vui lòng đánh dấu vào đây nếu bạn yêu cầu đăng ký Bảo hiểm y tế học đường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PT_SCHOLARSHIP')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PT_SCHOLARSHIP', 'Please tick here if you benefit from a Scholarship', 'Please tick here if you benefit from a Scholarship','Merk asseblief hier as jy voordeel trek uit n beurs','Vui lòng đánh dấu vào đây nếu bạn được hưởng Học bổng',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PT_MEDICAL_ISSUES')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PT_MEDICAL_ISSUES', 'Please tick here if you suffer from any medical issues or learning differences', 'Please tick here if you suffer from any medical issues or learning differences','Merk asseblief hier as jy aan enige mediese probleme of leerverskille ly','Vui lòng đánh dấu vào đây nếu bạn gặp phải bất kỳ vấn đề y tế nào hoặc sự khác biệt trong học tập',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PT_UP_TO_DATE_DETAILS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PT_UP_TO_DATE_DETAILS', 'In order to process your Program Transfer request, please ensure Personal Details, Contact Details, Passport Details and Parent and Sponsor details are up to date. (Insert hyperlink to the Student Profile here)', 'In order to process your Program Transfer request, please ensure Personal Details, Contact Details, Passport Details and Parent and Sponsor details are up to date. (Insert hyperlink to the Student Profile here)','Merk asseblief hier as jy aan enige mediese probleme of leerverskille ly','Vui lòng đánh dấu vào đây nếu bạn gặp phải bất kỳ vấn đề y tế nào hoặc sự khác biệt trong học tập',now(),1);
END IF;

END $$
CALL V20230726105941__Insert_dfr_HealthInsuranceProgTransfer() $$
DROP PROCEDURE IF EXISTS V20230726105941__Insert_dfr_HealthInsuranceProgTransfer $$
DELIMITER ;