DELIMITER $$
DROP PROCEDURE IF EXISTS V20230727155631__Create_DebarmentMultipleReason $$
CREATE PROCEDURE V20230727155631__Create_DebarmentMultipleReason()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='debarment_request_multiple_reason')) THEN 
 CREATE TABLE `debarment_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `debarmentRequestDetailId` BIGINT(20) NOT NULL,
  `debarmentReasonId` BIGINT(20) NULL,
  `reasonRemark` longtext NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_debarment_multiple_reason_request_detail_idx` (`debarmentRequestDetailId` ASC),
  INDEX `fk_debarment_request_multiple_reason_pw_reason_idx` (`debarmentReasonId` ASC),
  INDEX `fk_debarment_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_debarment_multiple_reason_terminationRequestDetail_id`
    FOREIGN KEY (`debarmentRequestDetailId`)
    REFERENCES `debarment_request_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_debarment_request_multiple_reason_pw_reason_id`
    FOREIGN KEY (`debarmentReasonId`)
    REFERENCES `debarment_reasons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_debarment_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;  

END $$
CALL V20230727155631__Create_DebarmentMultipleReason () $$ 
DROP PROCEDURE IF EXISTS V20230727155631__Create_DebarmentMultipleReason $$ 
DELIMITER ;