DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728142741__Create_HostelAplicationSetupMapping $$
CREATE PROCEDURE V20230728142741__Create_HostelAplicationSetupMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_application_setup_mapping')) THEN 
CREATE TABLE `hostel_application_setup_mapping` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`hostelApplicationSetupId` bigint NOT NULL,
`progBatchSeatConfigId` bigint NOT NULL,
`progBatchPeriodConfigId` bigint NULL DEFAULT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`hostelApplicationSetupId`) REFERENCES `hostel_application_setup` (`id`),
FOREIGN KEY (`progBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`),
FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
	
END IF; 

END $$
CALL V20230728142741__Create_HostelAplicationSetupMapping () $$ 
DROP PROCEDURE IF EXISTS V20230728142741__Create_HostelAplicationSetupMapping $$ 
DELIMITER ;