DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801135352__Alter_ApplicantDetailUrl $$
CREATE PROCEDURE V20230801135352__Alter_ApplicantDetailUrl()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_detail_url' AND column_name='applicantLanguageDetailId')) THEN 
ALTER TABLE  applicant_detail_url 
DROP FOREIGN KEY applicant_passport_detail_url_document_FK;
ALTER TABLE applicant_detail_url 
ADD COLUMN applicantLanguageDetailId BIGINT NULL AFTER lastUpdatedBy,
CHANGE COLUMN applicantPassportDetailId applicantPassportDetailId BIGINT NULL ,
ADD INDEX applicant_language_url_id_FK_idx (`applicantLanguageDetailId` ASC) VISIBLE;

ALTER TABLE applicant_detail_url 
ADD CONSTRAINT applicant_passport_detail_url_document_FK
  FOREIGN KEY (`applicantPassportDetailId`)
  REFERENCES applicant_passport_detail (`id`),
ADD CONSTRAINT applicant_language_url_id_FK
  FOREIGN KEY (`applicantLanguageDetailId`)
  REFERENCES applicant_language (`id`)
  ON DELETE NO ACTION ;

  END IF; 
END $$
CALL V20230801135352__Alter_ApplicantDetailUrl() $$
DROP PROCEDURE IF EXISTS V20230801135352__Alter_ApplicantDetailUrl $$
DELIMITER ;