DELIMITER $$
DROP PROCEDURE IF EXISTS V20230818143714__Alter_Alter_studentAcademicTopics $$
CREATE PROCEDURE V20230818143714__Alter_Alter_studentAcademicTopics()
BEGIN
IF NOT EXISTS (SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='student_academic_topics' and column_name in ('status','isPublished','createdBy','createdAt','updatedBy','updatedAt')) THEN
	ALTER TABLE student_academic_topics 
	ADD COLUMN `status` VARCHAR(50) NULL DEFAULT NULL AFTER `date`,
	ADD COLUMN `isPublished` TINYINT(1) NULL DEFAULT '0' AFTER `status`,
	ADD COLUMN `createdBy` BIGINT NULL DEFAULT NULL AFTER `isPublished`,
	ADD COLUMN `createdAt` DATETIME NULL DEFAULT NULL AFTER `createdBy`,
	ADD COLUMN `updatedBy` BIGINT NULL DEFAULT NULL AFTER `createdAt`,
	ADD COLUMN `updatedAt` DATETIME NULL AFTER `updatedBy`,
    
	ADD CONSTRAINT `fk_student_academic_topics_createBy`
	FOREIGN KEY (`createdBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
        
    ADD CONSTRAINT `fk_student_academic_topics_updatedBy`
	FOREIGN KEY (`updatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
END IF; 
END $$
CALL V20230818143714__Alter_Alter_studentAcademicTopics() $$
DROP PROCEDURE IF EXISTS V20230818143714__Alter_Alter_studentAcademicTopics $$
DELIMITER ;

select * from student_academic_topics;