DELIMITER $$
DROP PROCEDURE IF EXISTS V20230823151556__Insert_Add_PROF_SCALE_Template $$
CREATE PROCEDURE V20230823151556__Insert_Add_PROF_SCALE_Template()
BEGIN

IF NOT EXISTS ((select * from report_template where templateCode='SIS_GRADE_BOOK_P1_P2_PRE_SCHOOL_PROFICIENCY_SCALE')) THEN 

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES 
('2', 'SIS_GRADE_BOOK_P1_P2_PRE_SCHOOL_PROFICIENCY_SCALE', 'SIS Grade Book Pre School Dynamic Legend', 'SIS_GRADE_BOOK_P1_P2.png', 'CommonReport_SIS_MARKSHEET.jasper', 'EVALUATION_SUB_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SIS_GRADE_BOOK_P1_P2_PRE_SCHOOL_PROFICIENCY_SCALE.jasper', 'AcademiaLogo.png');

set @reportTempId = (select max(id) from report_template);

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'ACADEMICS_CODE', 'Proficiency', '1');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'PROFICIENCY_SCALE', 'Proficiency Scale', '1');    


INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'PROFICIENT', 'Proficient', '1'); 

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'DEVELOPING', 'Developing', '1'); 

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'EMERGING', 'Emerging', '1'); 

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'PROFICIENT_COMMENT', 'The student demonstrated good knowledge in relation to the learning standards Works independently', '1'); 

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'DEVELOPING_COMMENT', 'The student demonstrated some knowledge in relation to the learning standards.Works with some support.', '1'); 

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'EMERGING_COMMENT', 'The student is beginning to demonstrate basic knowledge in relation to the learning standards.Works with ongoing support.', '1'); 

END IF; 
END $$
CALL V20230823151556__Insert_Add_PROF_SCALE_Template() $$
DROP PROCEDURE IF EXISTS V20230823151556__Insert_Add_PROF_SCALE_Template $$
DELIMITER ;