DELIMITER $$
DROP PROCEDURE IF EXISTS V20230908095936__Insert_KCU_Final_Transcript $$
CREATE PROCEDURE V20230908095936__Insert_KCU_Final_Transcript()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );	

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KCU_FINAL_TRANSCRIPT')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'KCU_FINAL_TRANSCRIPT', 'KCU Final Transcript', 'KCU_FINAL_TRANSCRIPT.png', 'KCU_FINAL_TRANSCRIPT_CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'KCU_FINAL_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF;

set @tempId = (select max(id) from report_template where templateCode='KCU_FINAL_TRANSCRIPT' and templateName='KCU Final Transcript');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OFFICE_ACADEMIC_REGISTRAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_OFFICE_ACADEMIC_REGISTRAR', 'Office of the Academic Registrar', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ACADEMIC_TRANSCRIPT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ACADEMIC_TRANSCRIPT', 'ACADEMIC TRANSCRIPT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NAME', 'Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REG') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_REG', 'Reg. No', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SEX') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SEX', 'Sex', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DOB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DOB', 'Date of Birth', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NATIONALITY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NATIONALITY', 'Nationality', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PROGRAM', 'Programme', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SCHOOL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SCHOOL', 'School', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CODE', 'CODE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_COURSE_TITLE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_COURSE_TITLE', 'COURSE TITLE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CU') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CU', 'CU', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE', 'GRADE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REMARKS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_REMARKS', 'REMARKS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_RECESS_TERM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_RECESS_TERM', 'RECESS TERM', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GPA', 'GPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CGPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CGPA', 'CGPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_AWARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_AWARD', 'AWARD', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CUMULATIVE_GRADE_POINT_AVERAGE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CUMULATIVE_GRADE_POINT_AVERAGE', 'CUMULATIVE GRADE POINT AVERAGE', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CLASS_OF_AWARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CLASS_OF_AWARD', 'CLASS OF AWARD', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NOTE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NOTE', 'For key to Grades and Remarks, See Reverse', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ACADEMIC_REGISTRAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ACADEMIC_REGISTRAR', 'Academic Registrar', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NOTE1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NOTE1', ' Not valid without Official Stamp. Any Alteration whatsoever renders the transcript invalid', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ACADEMIC_YEAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ACADEMIC_YEAR', 'Academic Year', '1', now());
END IF;

END $$
CALL V20230908095936__Insert_KCU_Final_Transcript() $$
DROP PROCEDURE IF EXISTS V20230908095936__Insert_KCU_Final_Transcript $$
DELIMITER ;