DELIMITER $$
DROP PROCEDURE IF EXISTS V20231026135242__Insert_DMUK_INVOICE_STUDENT $$
CREATE PROCEDURE V20231026135242__Insert_DMUK_INVOICE_STUDENT()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_STUDENT_CODE' AND templateName='DMUK Invoice - Student')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('3', 'MANAGE_BILLS_STUDENT_CODE', 'DMUK Invoice - Student', 'Bill.png', 'DMUK_Invoice_Student_CommonReport_Bill.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'DMUK Invoice - Student.jasper', 'AcademiaLogo.png');

set @reportTempId= (select max(id) from report_template where   templateName='DMUK Invoice - Student'  );

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES(@reportTempId , 'TRANS_Billed To', 'Billed To', '1', NOW()),
(@reportTempId, 'TRANS_Invoice Date', 'Invoice Date', '1', NOW()),
(@reportTempId, 'TRANS_Invoice #', 'Invoice #', '1', NOW()),
(@reportTempId, 'TRANS_Due Date', 'Due Date', '1', NOW()),
(@reportTempId, 'TRANS_Fees Type', 'Fees Type', '1', NOW()),
(@reportTempId, 'TRANS_Amount', 'Amount', '1', NOW()),
(@reportTempId, 'TRANS_Proforma Invoice', 'Proforma Invoice', '1', NOW()),
(@reportTempId, 'TRANS_Line Items', 'Line Items', '1', NOW()),
(@reportTempId, 'TRANS_Rate', 'Rate', '1', NOW()),
(@reportTempId, 'TRANS_Total', 'Total', '1', NOW()),
(@reportTempId, 'TRANS_BelowTotal', 'Total', '1', NOW()),
(@reportTempId, 'TRANS_Tax', 'Tax', '1', NOW()),
(@reportTempId, 'TRANS_E-mail', 'E-mail', '1', NOW()),
(@reportTempId, 'TRANS_Contact No', 'Contact No', '1', NOW()),
(@reportTempId, 'TRANS_Application Id/Student ID', 'Application Id/Student ID', '1', NOW()),
(@reportTempId, 'TRANS_Subtotal', 'Subtotal', '1', NOW()),
(@reportTempId, 'TRANS_Discount amount', 'Discount amount', '1', NOW()),
(@reportTempId, 'TRANS_Total Amount Paid', 'Total Amount Paid', '1', NOW()),
(@reportTempId, 'TRANS_Total Amount Due', 'Total Amount Due', '1', NOW()),
(@reportTempId, 'TRANS_Comments', 'Comments', '1', NOW()),
(@reportTempId, 'TRANS_Comment1', '1. This proforma invoice is in USD to inform you about your tuition fee payment. Your actual invoice/acceptance act in KZT amount can be provided upon your request.', '1', NOW()),
(@reportTempId, 'TRANS_Comment2', '2. The above USD tuition fee amount will be converted to the KZT based on USD/KZT exchange rate of National Bank of Kazakhstan on the payment date.', '1', NOW()),
(@reportTempId, 'TRANS_Comment3', '', '1', NOW());


END IF; 

END $$
CALL V20231026135242__Insert_DMUK_INVOICE_STUDENT() $$
DROP PROCEDURE IF EXISTS V20231026135242__Insert_DMUK_INVOICE_STUDENT $$
DELIMITER ;