DELIMITER $$
DROP PROCEDURE IF EXISTS V20231102234902__Create_ApplicationProgramStatusSeedValue $$
CREATE PROCEDURE V20231102234902__Create_ApplicationProgramStatusSeedValue()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_program_status')) THEN  
CREATE TABLE `application_program_status`(
`id` bigint NOT NULL AUTO_INCREMENT,
`codeName` varchar(50) DEFAULT NULL,
`codeValue` varchar(50) DEFAULT NULL,
PRIMARY KEY (`id`)
);

 INSERT INTO `application_program_status` (`id`, `codeName`, `codeValue`) 
 VALUES  (1,"OFFER_LETTER_ACCEPTED","Offer letter accepted"),
 (2,"OFFER_LETTER_ISSUED","Offer letter issued"),
 (3,"OFFER_LETTER_REJECTED","Offer letter rejected"),
 (4,"OFFER_LETTER_DUE","Offer letter due"),
 (5,"ACTIVE","Active"),
  (6,"APPROVED","Approved"),
 (7,"ADMITTED","Admitted"),
 (8,"ADMITTED_ON_TRIAL","Admitted on trial"),
 (9,"ADMITTED_ON_PROVISIONAL","Admitted on provisional"),
 (10,"REJECTED","Rejected"),
 (11,"WITHDRAWN", "Withdrawn"),
 (12,"WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER", "Withdrawn after accepting offer letter"),
 (13,"CLOSED", "Closed"),
 (14,"PROVISIONAL_OFFER_ISSUED","Provisional offer issued"),
 (15,"PROVISIONAL_OFFER_REJECTED","Provisional offer rejected"),
 (16,"PROVISIONAL_OFFER_DUE","Provisional offer due"),
 (17,"OFFER_EXPIRED","Offer Expired"),
 (18,"PROVISIONAL_OFFER_EXPIRED","Provisional Offer Expired"),
 (19,"ESCALATED","Escalated"),
  (20,"ESCALATED_OFFER_REVIEWED","Escalated Offer Reviewed"),
   (21,"WAITING_LIST","Waiting List");

END IF; 

END $$
CALL V20231102234902__Create_ApplicationProgramStatusSeedValue () $$ 
DROP PROCEDURE IF EXISTS V20231102234902__Create_ApplicationProgramStatusSeedValue $$ 
DELIMITER ;