DELIMITER $$
DROP PROCEDURE IF EXISTS V20231108161629__Create_LeaseAgreementDocument $$
CREATE PROCEDURE V20231108161629__Create_LeaseAgreementDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lease_agreement_document')) THEN 
CREATE TABLE `lease_agreement_document`(
`id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `livingArrangementId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `lease_agreement_livingArrangementId_FK` FOREIGN KEY (`livingArrangementId`) REFERENCES living_arrangement(`id`),
  CONSTRAINT `lease_agreement_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `lease_agreement_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20231108161629__Create_LeaseAgreementDocument () $$ 
DROP PROCEDURE IF EXISTS V20231108161629__Create_LeaseAgreementDocument $$ 
DELIMITER ;