CREATE OR REPLACE VIEW `post_gl_invoice_receipt_view` AS
SELECT DISTINCT
func_inc_var_session_rec() AS `Id`,
al.id AS 'Academy_Location_Id',
al.academyName AS 'Academy_Name',
al.locationName AS 'Location_Name',
al.displayName AS 'Academy_Location_Name',
adm.code AS 'Admission_Id',
usr.code AS 'Student_Id',
usr.printName AS 'Student_Name',
btc.batchName AS 'Batch_Name',
prog.programName AS 'Program_Name',
bh.billNo  AS 'Payment_Number',
bh.billStatus AS 'Bill_Receipt_Status',
`bh`.`billingDate` AS `Date`,
bh.raiseBillCategory AS `Category`,
bfp.billableAmount AS 'Amount',
fh.feeHeadName AS 'Fee_Head',
fsm.stageName AS 'Fee_Stage_Name',
fpt.feePlanType AS 'Fee_Plan_Type',
fp.feePlanName AS 'Fee_Plan_Name',
case when bh.raiseBillCategory = 'BILL_PAYABLE' then dm.discountCode
ELSE NULL END AS 'Scholarship_Name',
CASE
WHEN (bh.raiseBillCategory = 'BILL_RECEIVABLE')
THEN cc.itemValue
ELSE
CASE
WHEN ( (bh.raiseBillCategory = 'BILL_PAYABLE') AND (fshc.discountCostCentreId IS NOT NULL) )
THEN  ccd.itemValue
ELSE cc.itemValue
END
END AS 'Cost_Center',
CASE
WHEN (bh.raiseBillCategory = 'BILL_RECEIVABLE')
THEN cc.description
ELSE
CASE
WHEN ( (bh.raiseBillCategory = 'BILL_PAYABLE') AND (fshc.discountCostCentreId IS NOT NULL) )
THEN  ccd.description
ELSE cc.description
END
END AS 'description',
CASE
WHEN (bh.raiseBillCategory = 'BILL_RECEIVABLE')
THEN cc.isControlAccount
ELSE
CASE
WHEN ( (bh.raiseBillCategory = 'BILL_PAYABLE') AND (fshc.discountCostCentreId IS NOT NULL) )
THEN  ccd.isControlAccount
ELSE cc.isControlAccount
END
END AS 'isControlAccount',
CASE
WHEN (bh.raiseBillCategory = 'BILL_RECEIVABLE')
THEN cc.controlAccountId
ELSE
CASE
WHEN ( (bh.raiseBillCategory = 'BILL_PAYABLE') AND (fshc.discountCostCentreId IS NOT NULL) )
THEN  ccd.controlAccountId
ELSE cc.controlAccountId
END
END AS 'controlAccountId',
-- CASE WHEN (fshc.discountCostCentreId IS NOT NULL) THEN ccd.itemValue ELSE cc.itemValue END AS 'Cost Center',
bh.billGenerationType AS 'billGenerationType',
bt.billedUserType AS 'billedUserType',
bt.raiseBillType AS 'raiseBillType',
        (CASE
            WHEN (bh.raiseBillCategory = 'BILL_RECEIVABLE') THEN cc.fundType
            ELSE (CASE
                WHEN
                    ((bh.raiseBillCategory = 'BILL_PAYABLE')
                        AND (fshc.discountCostCentreId IS NOT NULL))
                THEN
                    ccd.fundType
                ELSE cc.fundType
            END)
        END) AS 'fundType'

FROM bill_header bh
INNER JOIN billed_user_type bt ON (bt.id = bh.raiseBillFor)
Left JOIN admission adm ON (bh.studentId = adm.studentId AND bh.programBatchSeatConfigId = adm.programBatchSeatConfigId)
LEFT JOIN users usr ON (adm.studentId = usr.id)
LEFT JOIN prog_batch_period_config pbpc ON ( adm.programBatchPeriodConfigId = pbpc.id )
LEFT JOIN batches btc ON (pbpc.programBatchId = btc.id)
LEFT JOIN programs prog ON (btc.programId = prog.id)
LEFT JOIN academy_location al ON (prog.academyLocationId = al.id)
LEFT JOIN bill_fee_plan_rule_stage bfp ON (bh.id = bfp.billId)
LEFT JOIN applicant_student_discount_master asdm ON (bh.studentId = asdm.studentId AND bh.programBatchSeatConfigId = asdm.programBatchSeatConfigId)
LEFT JOIN discount_master dm ON (asdm.discountMasterId = dm.id)
LEFT JOIN fee_stage_head_config fshc ON (bfp.feeStageHeadConfigId = fshc.id)
LEFT JOIN cost_centre cc ON (cc.id = fshc.costCentreId AND fshc.whetherPayableDiscount = 0)
LEFT JOIN cost_centre ccd ON (ccd.id = fshc.discountCostCentreId AND fshc.whetherPayableDiscount = 1)
LEFT JOIN fee_heads fh ON (fshc.feeHeadId = fh.id)
LEFT JOIN fee_plan_rule_stage fprs ON (fshc.feePlanRuleStageId = fprs.id)
LEFT JOIN fee_plan_rules fpr ON (fpr.id = fprs.feePlanRuleId)
LEFT JOIN fee_plan fp ON (fp.id = fpr.feePlanId)
LEFT JOIN fee_stage_master fsm ON (fprs.stageId = fsm.id)
LEFT JOIN fee_plan_type fpt ON (fsm.feePlanType = fpt.id)
where usr.id  IS NOT NULL AND bh.totalAmount IS NOT null

UNION

SELECT
func_inc_var_session_rec() AS `Id`,
al.id AS 'Academy_Location_Id',
al.academyName AS 'Academy_Name',
al.locationName AS 'Location_Name',
al.displayName AS 'Academy_Location_Name',
adm.code AS 'Admission_Id',
usr.code AS 'Student_Id',
usr.printName AS 'Student_Name',
btc.batchName AS 'Batch_Name',
prog.programName AS 'Program_Name',
rh.receiptNo  AS 'Payment_Number',
rh.`status` AS 'Bill_Receipt_Status',
`rh`.transactionDate AS `Date`,
rh.voucherType  AS `Category`,
rh.amount AS 'Amount',
'Total amount Paid' AS 'Fee_Head',
'Total amount Paid' AS 'Fee_Stage_Name',
'Total amount Paid' AS 'Fee_Plan_Type',
NULL AS 'Fee_Plan_Name',
null AS 'Scholarship_Name',
cc.itemValue AS 'Cost_Center',
cc.description AS 'description',
cc.isControlAccount AS 'isControlAccount',
cc.controlAccountId AS 'controlAccountId',
NULL AS 'billGenerationType',
btr.billedUserType AS 'billedUserType',
btr.raiseBillType AS 'raiseBillType',
cc.fundType AS 'fundType'
FROM receipt_header rh
INNER JOIN billed_user_type btr ON (btr.id = rh.receiptFor)
Left JOIN admission adm ON (rh.studentId = adm.studentId)
LEFT JOIN users usr ON (adm.studentId = usr.id)
LEFT JOIN prog_batch_period_config pbpc ON ( adm.programBatchPeriodConfigId = pbpc.id )
LEFT JOIN cost_centre cc ON (cc.id = rh.costCentreId)
LEFT JOIN batches btc ON (pbpc.programBatchId = btc.id)
LEFT JOIN programs prog ON (btc.programId = prog.id)
LEFT JOIN academy_location al ON (prog.academyLocationId = al.id)
WHERE (usr.id  IS NOT NULL)
GROUP BY rh.id

UNION

SELECT
func_inc_var_session_rec() AS `Id`,
al.id AS 'Academy_Location_Id',
al.academyName AS 'Academy_Name',
al.locationName AS 'Location_Name',
al.displayName AS 'Academy_Location_Name',
adm.code AS 'Admission_Id',
usr.code AS 'Student_Id',
usr.printName AS 'Student_Name',
btc.batchName AS 'Batch_Name',
prog.programName AS 'Program_Name',
ph.paymentVoucherNo  AS 'Payment_Number',
ph.`status` AS 'Bill_Receipt_Status',
ph.transactionDate AS `Date`,
ph.voucherType  AS `Category`,
ph.amount AS 'Amount',
'Total amount Paid' AS 'Fee_Head',
'Total amount Paid' AS 'Fee_Stage_Name',
'Total amount Paid' AS 'Fee_Plan_Type',
NULL AS 'Fee_Plan_Name',
null AS 'Scholarship_Name',
cc.itemValue AS 'Cost_Center',
cc.description AS 'description',
cc.isControlAccount AS 'isControlAccount',
cc.controlAccountId AS 'controlAccountId',
NULL AS 'billGenerationType',
btp.billedUserType AS 'billedUserType',
btp.raiseBillType AS 'raiseBillType',
cc.fundType AS 'fundType'
FROM payment_header ph
INNER JOIN billed_user_type btp ON (btp.id = ph.paymentFor)
Left JOIN admission adm ON (ph.studentId = adm.studentId)
LEFT JOIN users usr ON (adm.studentId = usr.id)
LEFT JOIN prog_batch_period_config pbpc ON ( adm.programBatchPeriodConfigId = pbpc.id )
LEFT JOIN cost_centre cc ON (cc.id = ph.costCentreId)
LEFT JOIN batches btc ON (pbpc.programBatchId = btc.id)
LEFT JOIN programs prog ON (btc.programId = prog.id)
LEFT JOIN academy_location al ON (ph.academyLocationId = al.id)
WHERE (usr.id  IS NOT NULL)
GROUP BY ph.id;