DELIMITER $$
DROP PROCEDURE IF EXISTS V20231221155157__Create_ApplicantacademicTopicDoc $$
CREATE PROCEDURE V20231221155157__Create_ApplicantacademicTopicDoc()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_academic_topic_documents')) THEN 
CREATE TABLE `applicant_academic_topic_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `applicationAcademicTopicId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_applicant_academic_topic_documents_documents` (`documentId`),
  KEY `FK_applicant_academic_topic_documents_QTD` (`applicationAcademicTopicId`),
  KEY `FK_applicant_academic_topic_documents_usersId` (`lastUpdatedBy`),
  CONSTRAINT `FK_applicant_academic_topic_documents_QTD` FOREIGN KEY (`applicationAcademicTopicId`) REFERENCES `application_academic_topics` (`id`),
  CONSTRAINT `FK_applicant_academic_topic_documents_usersId` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK_applicant_academic_topic_documents_documents` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20231221155157__Create_ApplicantacademicTopicDoc () $$ 
DROP PROCEDURE IF EXISTS V20231221155157__Create_ApplicantacademicTopicDoc $$ 
DELIMITER ;