DELIMITER $$
DROP PROCEDURE IF EXISTS V20240110175154__Create_AddAdmissionInactiveReason $$
CREATE PROCEDURE V20240110175154__Create_AddAdmissionInactiveReason()
BEGIN
 IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_inactive_reason')) THEN 
		
		CREATE TABLE `admission_inactive_reason`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,	
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		UNIQUE `admission_inactive_reason_UNIQUE`(itemCode),
		CONSTRAINT `admission_inactive_reason_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master where tableName='admission_inactive_reason' AND masterName='ADMISSION_INACTIVE_REASON')) THEN
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@standardMasterMaxId+1,'admission_inactive_reason', 'ADMISSION_INACTIVE_REASON', 'Program & Courses', 'COMMON_MASTER', 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@ItemsMaxId + 1,'itemCode', 'ITEM_CODE', @standardMasterMaxId+1 , 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId + 1,'itemValue', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
	END IF;
    
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'ADMISSION_INACTIVE_REASON')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'ADMISSION_INACTIVE_REASON', 'Admission Inactive Reason', 'Admission Inactive Reason','Toelating onaktiewe rede','tiếng việt',now(),1);
	END IF;


END $$
CALL V20240110175154__Create_AddAdmissionInactiveReason () $$ 
DROP PROCEDURE IF EXISTS V20240110175154__Create_AddAdmissionInactiveReason $$ 
DELIMITER ;