DELIMITER $$
DROP PROCEDURE IF EXISTS V20240222121420__Alter_PassingOut $$
CREATE PROCEDURE V20240222121420__Alter_PassingOut()
BEGIN

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'passing_outs' and column_name = 'rejectedDateTime')) THEN 
ALTER TABLE `passing_outs` 	
ADD COLUMN `rejectedDateTime` datetime DEFAULT NULL AFTER `passOutPath`;	
END IF;

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'passing_outs' and column_name = 'rejectedBy')) THEN 
ALTER TABLE `passing_outs` 	
ADD COLUMN `rejectedBy` BIGINT(20) NULL DEFAULT NULL AFTER `rejectedDateTime`,

ADD INDEX `fk_PO_rejectedBy_idx` (`rejectedBy`),

ADD CONSTRAINT `fk_passing_outs_rejectedBy`
    FOREIGN KEY (`rejectedBy`)
    REFERENCES `users` (`id`);
END IF;

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'passing_outs' and column_name = 'rejectedRemark')) THEN 
ALTER TABLE `passing_outs` 	
ADD COLUMN `rejectedRemark` varchar(255) DEFAULT NULL AFTER `rejectedBy`;

END IF; 

END $$
CALL V20240222121420__Alter_PassingOut() $$
DROP PROCEDURE IF EXISTS V20240222121420__Alter_PassingOut $$
DELIMITER ;