DELIMITER $$
DROP PROCEDURE IF EXISTS V20240229114916__Insert_Student_IDCard_AEI $$
CREATE PROCEDURE V20240229114916__Insert_Student_IDCard_AEI()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENT_ID_CARD_AEI')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'STUDENT_ID_CARD_AEI', 'AEI Group Student ID Card', 'STUDENT_ID_CARD_AEI.png', 'CommonReport_IdCard_Horizontally_AEI.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally_AEI.jasper', 'FooterBlank_IdCard_Horizontally_AEI.jasper', '1', '1', 'STUDENT_ID_CARD_AEI.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STUDENT_ID_CARD_AEI'))) THEN
	set @reportTempId = (select id from report_template where templateCode ='STUDENT_ID_CARD_AEI');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
	VALUES (@reportTempId, 'TRANS_HEADER', 'STUDENT IDENTITY CARD', '1'),
	(@reportTempId, 'TRANS_ENROLMENT_NO', 'Admission ID:', '1'),
	(@reportTempId, 'TRANS_SCHOLAR_NO', 'Student ID:', '1'),
	(@reportTempId, 'TRANS_NAME', 'Name:', '1'),
	(@reportTempId, 'TRANS_FATHER', 'Father’s Name:', '1'),
	(@reportTempId, 'TRANS_COLLEGE', 'Department:', '1'),
	(@reportTempId, 'TRANS_PROGRAM', 'Program Name:', '1'),
	(@reportTempId, 'TRANS_ADMISSION_SESSION', 'Batch:', '1'),
	(@reportTempId, 'TRANS_REGISTRAR', 'Principals Signature', '1'),
	(@reportTempId, 'TRANS_DATE', 'Date of issue:', '1'),
	(@reportTempId, 'TRANS_BLOOD_GROUP', 'Blood Group:', '1'),
	(@reportTempId, 'TRANS_PARENTS_CONTACT_NO', 'Mobile No:', '1'),
	(@reportTempId, 'TRANS_ADDRESS', 'Student Address:', '1'),
	(@reportTempId, 'TRANS_VALID_UPTO', 'Valid Upto:', '1'),
	(@reportTempId, 'TRANS_GENDER', 'Gender:', '1'),
	(@reportTempId, 'TRANS_DATE_OF_BIRTH', 'Date of Birth:', '1'),
	(@reportTempId, 'TRANS_RULES_REGULATIONS', 'Students are required to wear their ID cards while on College premises', '1');
  END IF;
END $$
CALL V20240229114916__Insert_Student_IDCard_AEI() $$
DROP PROCEDURE IF EXISTS V20240229114916__Insert_Student_IDCard_AEI $$
DELIMITER ;