DELIMITER $$
DROP PROCEDURE IF EXISTS V20240320111209__Create_bbUserCourseMembership $$
CREATE PROCEDURE V20240320111209__Create_bbUserCourseMembership()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='blackboard_user_course_membership_mapping')) THEN 
CREATE TABLE blackboard_user_course_membership_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    membershipId VARCHAR(255),
    blackboardUserId VARCHAR(255),
    academiaUserId bigint NOT NULL,
	blackboardCourseId VARCHAR(255),
	academiaCourseVariantId bigint NOT NULL,
    courseRoleId VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_blackboard_user_course_mem_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_blackboard_user_course_mapping_academiaCourseVariantId_idx (academiaCourseVariantId),
  KEY fk_blackboard_user_course_mapping_academiaUserId_idx (academiaUserId),
  CONSTRAINT fk_blackboard_user_course_mem_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_blackboard_user_course_mapping_academiaCourseVariantId FOREIGN KEY (academiaCourseVariantId) REFERENCES course_variants (id),
  CONSTRAINT fk_blackboard_user_course_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240320111209__Create_bbUserCourseMembership () $$ 
DROP PROCEDURE IF EXISTS V20240320111209__Create_bbUserCourseMembership $$ 
DELIMITER ;