DELIMITER $$
DROP PROCEDURE IF EXISTS V20240415172442__Create_OUMReceiptSetup $$
CREATE PROCEDURE V20240415172442__Create_OUMReceiptSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MANAGE_RECEIPT_CODE' and `templateName`='OUM Receipt')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('1', 'MANAGE_RECEIPT_CODE', 'OUM Receipt', 'MANAGE_RECEIPT_CODE.png', 'CommonReport_MANAGE_RECEIPT_CODE_OUM.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'MANAGE_RECEIPT_CODE_OUM.jasper', 'AcademiaLogo.png');
set @OUMReceipt = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_CODE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@OUMReceipt , 'TRANS_RECEIPT', 'Receipt', '1', NOW()),
(@OUMReceipt , 'TRANS_RECEIPT_NO', 'Receipt No:', '1', NOW()),
(@OUMReceipt , 'TRANS_RECEIPT_DATE', 'Receipt Date:', '1', NOW()),
(@OUMReceipt , 'TRANS_STUDENT_NAME', 'Name:', '1', NOW()),
(@OUMReceipt , 'TRANS_STUDENT_ID', 'Student ID:', '1', NOW()),
(@OUMReceipt , 'TRANS_INTAKE', 'Intake:', '1', NOW()),
(@OUMReceipt , 'TRANS_APPLICATION_NO', 'Application No.:', '1', NOW()),
(@OUMReceipt , 'TRANS_APPLICATION_ID', 'Applicant Id:', '1', NOW()),
(@OUMReceipt , 'TRANS_PROGRAM_NAME', 'Program Name:', '1', NOW()),
(@OUMReceipt , 'TRANS_PARTICULARS', 'Particular', '1', NOW()),
(@OUMReceipt , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@OUMReceipt , 'TRANS_PAID_SUTDENT', 'Total Fees paid by Student', '1', NOW()),
(@OUMReceipt , 'TRANS_TOTAL', 'TOTAL', '1', NOW()),
(@OUMReceipt , 'TRANS_TRANSACTION_TYPE', 'Transaction Type', '1', NOW()),
(@OUMReceipt , 'TRANS_REFERENCE_NUMBER', 'Reference Number', '1', NOW()),
(@OUMReceipt , 'TRANS_DATE', 'Date', '1', NOW()),
(@OUMReceipt , 'TRANS_RECEIVED_A_SUM_OF', 'Received a sum of', '1', NOW()),
(@OUMReceipt , 'TRANS_DESCRIPTION', 'This is a computer-generated document and requires no authentication. If you have any queries, contact us by email at feesfinance@open.ac.mu ', '1', NOW()),
(@OUMReceipt , 'TRANS_PAGE', 'Page', '1', NOW()),
(@OUMReceipt , 'TRANS_OF', 'of', '1', NOW());

END IF; 
END $$
CALL V20240415172442__Create_OUMReceiptSetup () $$ 
DROP PROCEDURE IF EXISTS V20240415172442__Create_OUMReceiptSetup $$ 
DELIMITER ;