DELIMITER $$
DROP PROCEDURE IF EXISTS V20240424155901__Update_AppHostelOfferLetterRecipient $$
CREATE PROCEDURE V20240424155901__Update_AppHostelOfferLetterRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="APPLICANT_HOSTEL_OFFER_LETTER_RCPNT") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="APPLICANT_HOSTEL_OFFER_LETTER_RCPNT");

update sql_dtprovider set sqlQuery="SELECT DISTINCT
    T1.id AS ID,
    T3.code AS APPLICATION_ID,
    T2.firstName AS FIRST_NAME,
	T2.emailId AS EMAIL_ID,
    T2.firstName AS APP_FIRST_NAME,
    T2.middleName AS APP_MIDDLE_NAME,
    T2.lastName AS APP_LAST_NAME,
	T2.printName AS APP_PRINT_NAME,
	T2.externalSysRefOne AS HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE,
	T2.initials AS HOSTEL_INITIAL,
	T5.salutationName AS HOSTEL_SALUTATION,
	T9.locationName AS HOSTEL_OFFERED_LOCATION,
	T8.itemValue AS HOSTEL_ACADEMIC_TERM,
	T10.itemValue AS HOSTEL_DEPOSIT_CATEGORY,
	T11.categoryDescription AS HOSTEL_RESERVATION_CATEGORY,
    T4.logoUrl AS LOGO_URL,
	'APPLICANT' AS USER_TYPE_KEY,
     ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T4.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T4.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T4.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T4.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    hostel_offer_detail T1
        LEFT OUTER JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    application T3 ON T3.applicantPersonId = T2.id
        LEFT OUTER JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
     LEFT OUTER JOIN
	multi_language ml on ml.id=T2.correspondence_language
		LEFT OUTER JOIN
	salutations T5 on T5.id = T2.salutationId
		LEFT OUTER JOIN
    applicant_hostel_requirement T6 ON T6.id = T1.applicantHostelRequirementId
		LEFT OUTER JOIN	
	hostel_application_setup T7 ON T7.id = T6.waitingListTypeSetupId   
        LEFT OUTER JOIN
    academic_term T8 ON T8.id = T7.year
		LEFT OUTER JOIN
    locations T9 ON T9.id = T1.locationId
		LEFT OUTER JOIN
    hostel_student_category T10 ON T10.id = T1.hostelStudentCategoryId
		LEFT OUTER JOIN
    reservation_category T11 ON T11.id = T1.reservationCategoryId
    LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)", jsonString='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "APP_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "printName",
            "resultKey": "APP_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "externalSysRefOne",
            "resultKey": "HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "initials",
            "resultKey": "HOSTEL_INITIAL",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "salutationName",
            "resultKey": "HOSTEL_SALUTATION",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "locationName",
            "resultKey": "HOSTEL_OFFERED_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "itemValue",
            "resultKey": "HOSTEL_ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "itemValue",
            "resultKey": "HOSTEL_DEPOSIT_CATEGORY",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "categoryDesc",
            "resultKey": "HOSTEL_RESERVATION_CATEGORY",
            "displayCode": "",
            "displayOrder": 14
        }
    ]}'
   where dataProviderId=@dtProviderId;  

END IF; 
SET SQL_SAFE_UPDATES=1;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_DEPOSIT_CATEGORY')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_DEPOSIT_CATEGORY', 'Deposit Category', 'Deposit Category', 'Deposito Kategorie', 'Danh mục tiền gửi',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_RESERVATION_CATEGORY')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_RESERVATION_CATEGORY', 'Reservation Category', 'Reservation Category', 'Besprekingskategorie', 'Hạng mục đặt chỗ',now(),1);
END IF;

END $$
CALL V20240424155901__Update_AppHostelOfferLetterRecipient () $$
DROP PROCEDURE IF EXISTS V20240424155901__Update_AppHostelOfferLetterRecipient $$
DELIMITER ;