DELIMITER $$
DROP PROCEDURE IF EXISTS V20240607150745__Update_IndepNonExamChairPerofExamiPanel $$
CREATE PROCEDURE V20240607150745__Update_IndepNonExamChairPerofExamiPanel()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='INDEPENDENT_NON-EXAMINING_CHAIRPERSON_OF_EXAMINATION_PANEL_INFO')) THEN 
if not exists (select id from dydt_data_provider where providerName='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL' and priority=1) then
INSERT INTO `dydt_data_provider` (`providerName`, `priority`) VALUES ('INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL', '1');
end if;
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL');

update dydt_data_line_item set sqlSelectQueryDef="SELECT T1.id AS id,
T4.firstName AS ind_non_exam_char_of_exam_panel_first_name,
T4.middleName AS ind_non_exam_char_of_exam_panel_middle_name,
T4.lastName AS ind_non_exam_char_of_exam_panel_last_name,
T4.alternateEmailId AS ind_non_exam_char_of_exam_panel_alternative_email_id,
T4.emailId AS ind_non_exam_char_of_exam_panel_email_id,
T4.phoneNo AS ind_non_exam_char_of_exam_panel_telephone_no,
T4.mobileNumber AS ind_non_exam_char_of_exam_panel_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS ind_non_exam_char_of_exam_panel_address,
T13.code AS ind_non_exam_char_of_exam_panel_id,
T11.salutationName AS ind_non_exam_char_of_exam_panel_title,
T12.itemValue AS ind_non_exam_char_of_exam_panel_gender,
T15.deptName AS ind_non_exam_char_of_exam_panel_department
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=6
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T5.userId
left join department T15 on T15.id =T5.departmentId" where dataSourceCode='INDEPENDENT_NON-EXAMINING_CHAIRPERSON_OF_EXAMINATION_PANEL_INFO'
and dataProviderId=@dydtdataproviderId;

#------------------TRANSLATIONS---------------------

set @dydtdatalinitemId=(select id from dydt_data_line_item where dataSourceCode='INDEPENDENT_NON-EXAMINING_CHAIRPERSON_OF_EXAMINATION_PANEL_INFO' and dataProviderId=@dydtdataproviderId);

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_first_name' and dataProviderLineItemId=@dydtdatalinitemId) then
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('ind_non_exam_char_of_exam_panel_first_name', 'Independent Non-Examining Chairperson of Examination Panel First Name',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_middle_name' and dataProviderLineItemId=@dydtdatalinitemId) then
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES  ('ind_non_exam_char_of_exam_panel_middle_name', 'Independent Non-Examining Chairperson of Examination Panel Middle Name',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_last_name' and dataProviderLineItemId=@dydtdatalinitemId) then
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES  ('ind_non_exam_char_of_exam_panel_last_name', 'Independent Non-Examining Chairperson of Examination Panel Last Name',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_address' and dataProviderLineItemId=@dydtdatalinitemId) then
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES  ('ind_non_exam_char_of_exam_panel_address', 'Independent Non-Examining Chairperson of Examination Panel Address',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_email_id' and dataProviderLineItemId=@dydtdatalinitemId) then
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('ind_non_exam_char_of_exam_panel_email_id', 'Independent Non-Examining Chairperson of Examination Panel Email ID',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_alternative_email_id' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_alternative_email_id', 'Independent Non-Examining Chairperson of Examination Panel Alternative Email ID',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_telephone_no' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_telephone_no', 'Independent Non-Examining Chairperson of Examination Panel Telephone No.',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_mobile_no' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_mobile_no', 'Independent Non-Examining Chairperson of Examination Panel Mobile No.',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_id' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_id', 'Independent Non-Examining Chairperson of Examination Panel ID',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_title' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_title', 'Independent Non-Examining Chairperson of Examination Panel Title',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_gender' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_gender', 'Independent Non-Examining Chairperson of Examination Panel Gender',@dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * from dydt_templateparams_translations where translationCode='ind_non_exam_char_of_exam_panel_department' and dataProviderLineItemId=@dydtdatalinitemId) then
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('ind_non_exam_char_of_exam_panel_department', 'Independent Non-Examining Chairperson of Examination Panel Department',@dydtdatalinitemId);
END IF;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240607150745__Update_IndepNonExamChairPerofExamiPanel () $$
DROP PROCEDURE IF EXISTS V20240607150745__Update_IndepNonExamChairPerofExamiPanel $$
DELIMITER ;