DELIMITER $$
DROP PROCEDURE IF EXISTS fatchFacultyToBePushInCanvas $$
CREATE PROCEDURE fatchFacultyToBePushInCanvas(jobLastRunTimestamp timestamp)
BEGIN
SELECT
    func_inc_var_session_rec() AS `Id`,
    user.id as userId,
    user.code as userCode,
    user.printName as userName,
    user.shortName as shortName,
    staffPerson.emailId as email,
    location.id as locationId,
	userMapping.canvasUserId as canvasUserId,
	"FACULTY" as role
FROM
    users AS user
		left JOIN
	canvas_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		 JOIN
    staffs AS stf ON stf.userId = user.id
         JOIN
    persons AS staffPerson ON (staffPerson.id = stf.personId and staffPerson.emailId is not null)
		JOIN
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN
	academy_location AS location ON location.id=ual.academyLocationId
        left JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        left JOIN 
    roles AS role ON role.id = ualr.roleId
   where userMapping.id is null and (role.roleName ="FACULTY" or stf.whetherFaculty=true) and user.status = true group by user.id,location.id
    UNION ALL SELECT 
        func_inc_var_session_rec() AS `Id`,user.id as userId, user.code as userCode,  user.printName as userName, user.shortName as shortName,staffPerson.emailId as email,location.id as locationId, userMapping.canvasUserId as canvasUserId,"FACULTY" as role
FROM
   users AS user
		 JOIN
    staffs AS stf ON stf.userId = user.id
         JOIN
    persons AS staffPerson ON (staffPerson.id = stf.personId and staffPerson.emailId is not null)
		JOIN
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN
	academy_location AS location ON location.id=ual.academyLocationId
        left JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        left JOIN 
    roles AS role ON role.id = ualr.roleId
        JOIN
	canvas_user_mapping as userMapping ON (userMapping.academiaUserId=user.id and location.id=userMapping.academyLocationId)
    where (role.roleName ="FACULTY" or stf.whetherFaculty=true) and user.status = true and user.lastUpdate > jobLastRunTimestamp group by user.id,location.id;
END $$ 
DELIMITER ;