DELIMITER $$
DROP PROCEDURE IF EXISTS V20240621170328__Insert_CeremonyIdGen $$
CREATE PROCEDURE V20240621170328__Insert_CeremonyIdGen()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

IF NOT EXISTS (select * from id_column_available where tableName='ceremony' and columnName='ceremonyId') THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('ceremony','ceremonyId');
END IF;

IF NOT EXISTS (select * from id_entity_setting where tableName='ceremony' and idGenerationTable='ceremony' and whetherFullyConfigurable=TRUE and dynanicFieldAvailable=FALSE and searchConfigCode is NULL) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) 
VALUES('ceremony','ceremony',TRUE,FALSE,NULL,1,@currentTimeStamp);
END IF;
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);

IF NOT EXISTS (select * from id_definition where idEntitySettingId=@idEntitySettingId and idFormatType='ALPHA_NUMERIC' AND idColumn='ceremonyId') THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) 
VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','ceremonyId',0,0,1,@currentTimeStamp,0);
END IF;


SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
IF NOT EXISTS (SELECT * FROM id_format where idDefinitionId=@idDefinitionId and seqNo=1) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
END IF;


SET @idFormat=(SELECT MAX(id) FROM id_format);
IF NOT EXISTS (SELECT * FROM id_format_alphanumeric WHERE id=@idFormat and prefix='CER' and suffix='' and startFrom=1) THEN
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'CER','',1);
END IF;

END $$
CALL V20240621170328__Insert_CeremonyIdGen() $$
DROP PROCEDURE IF EXISTS V20240621170328__Insert_CeremonyIdGen $$
DELIMITER ;