DELIMITER $$
DROP PROCEDURE IF EXISTS V20240712145207__Create_MarkEntryEmailAttachment $$
CREATE PROCEDURE V20240712145207__Create_MarkEntryEmailAttachment()
BEGIN


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='mark_entry_email_attachment')) THEN 
CREATE TABLE `mark_entry_email_attachment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `eventId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `attachmentPath` VARCHAR(255) NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_mark_entry_email_attachment_courseVariantId_idx` (`courseVariantId`),
  KEY `fk_mark_entry_email_attachment_evaluationPlanId_idx` (`evaluationPlanId`),
  KEY `fk_mark_entry_email_attachment_periodId_idx` (`periodId`),
  KEY `fk_mark_entry_email_attachment_eventId_idx` (`eventId`),
  KEY `fk_mark_entry_email_attachment_facultyId_idx` (`facultyId`),
  KEY `fk_mark_entry_email_attachment_lastUpdatedBy_idx` (`lastUpdatedBy`),
  
  CONSTRAINT `fk_mark_entry_email_attachment_courseVariantId_idx` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `fk_mark_entry_email_attachment_evaluationPlanId_idx` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `fk_mark_entry_email_attachment_periodId_idx` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_mark_entry_email_attachment_eventId_idx` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `fk_mark_entry_email_attachment_facultyId_idx` FOREIGN KEY (`facultyId`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_mark_entry_email_attachment_lastUpdatedBy_idx` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240712145207__Create_MarkEntryEmailAttachment () $$ 
DROP PROCEDURE IF EXISTS V20240712145207__Create_MarkEntryEmailAttachment $$ 
DELIMITER ;