DELIMITER $$
DROP PROCEDURE IF EXISTS V20240725170134__Update_ProgramCompletionDetail $$
CREATE PROCEDURE V20240725170134__Update_ProgramCompletionDetail()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM information_schema.referential_constraints WHERE constraint_schema=DATABASE() AND table_name='program_completion_details' and constraint_name='FK_programCompletionDetails_awardTypeId')) THEN

INSERT INTO program_completion_award_type_csm
(id,itemCode,itemValue,sequenceNo,activeStatus,lastUpdatedBy,lastUpdate)
select aa.id, aa.itemCode, aa.itemValue, aa.id, true, aa.lastUpdatedBy, aa.lastUpdate
from academic_award aa
left join program_completion_award_type_csm csm on aa.id = csm.id
where csm.id is null;

ALTER TABLE program_completion_details
DROP FOREIGN KEY FK_programCompletionDetails_awardTypeId;

ALTER TABLE program_completion_details
ADD constraint `fk_award_csm_awardTypeId` FOREIGN KEY (awardTypeId) REFERENCES program_completion_award_type_csm(id);
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240725170134__Update_ProgramCompletionDetail () $$
DROP PROCEDURE IF EXISTS V20240725170134__Update_ProgramCompletionDetail $$
DELIMITER ;