DELIMITER $$
DROP PROCEDURE IF EXISTS fatchFacultyToBePushInBB $$
CREATE PROCEDURE fatchFacultyToBePushInBB()
BEGIN
SELECT 
    user.id as id,
    user.code as userCode,
    user.printName as userName,
    user.firstName as given,
    user.lastName as family,
    user.middleName as middle,
    staffPerson.emailId as email,
	staffPerson.birthDate as birthDate,
	staffGen.itemValue as gender,
	'FACULTY' as role
FROM
    users AS user
		left JOIN
	blackboard_user_mapping as userMapping ON user.id=userMapping.academiaUserId
         JOIN
    staffs AS stf ON stf.userId = user.id
         JOIN
    persons AS staffPerson ON staffPerson.id = stf.personId
         JOIN
	gender as staffGen On staffGen.id = staffPerson.genderId
		 JOIN
    user_academy_locations AS ual ON ual.userId = user.id
         left JOIN
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
		left JOIN
    roles AS role ON role.id = ualr.roleId
    where userMapping.id is null and (role.roleName ="FACULTY" or stf.whetherFaculty=true) and user.status=true group by user.id;
    
END $$ 
DELIMITER ;