DELIMITER $$
DROP PROCEDURE IF EXISTS V20240816114256__Insert_KCU_STAFF_ID_CARD_2 $$
CREATE PROCEDURE V20240816114256__Insert_KCU_STAFF_ID_CARD_2()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KCU_STAFF_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'KCU_STAFF_ID_CARD', 'KCU Staff ID Card', 'id_card_front.png', 'CommonReport_KCU_STAFF_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'KCU Staff ID Card.jasper', 'AcademiaLogo.png');
END IF; 

set @KCU_STAFF_ID_CARD = (select max(id) from report_template where templateCode ='KCU_STAFF_ID_CARD');

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE1', 'P.O Box 88, Kampala Uganda', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE2', 'Bunga Hill main campus', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE3', '+256 705 444 540, +256 784 290 233', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE4')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE4', 'contact@kcu.ug/www.kcu.ac.ug', '1', NOW());
END IF;

END $$
CALL V20240816114256__Insert_KCU_STAFF_ID_CARD_2() $$
DROP PROCEDURE IF EXISTS V20240816114256__Insert_KCU_STAFF_ID_CARD_2 $$
DELIMITER ;