DELIMITER $$
DROP PROCEDURE IF EXISTS V20240903170349__Insert_EM_NORMANDIE_STAFF_ID_CARD $$
CREATE PROCEDURE V20240903170349__Insert_EM_NORMANDIE_STAFF_ID_CARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'EM_NORMANDIE_STAFF_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'EM_NORMANDIE_STAFF_ID_CARD', 'EM Normandie Staff ID', 'id_card_front.png', 'CommonReport_EM_NORMANDIE_STAFF_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'EM Normandie Staff ID.jasper', 'AcademiaLogo.png');
END IF; 

set @EM_NORMANDIE_STAFF_ID_CARD = (select max(id) from report_template where templateCode ='EM_NORMANDIE_STAFF_ID_CARD');

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@EM_NORMANDIE_STAFF_ID_CARD and keyValue='TRANS_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@EM_NORMANDIE_STAFF_ID_CARD, 'TRANS_ID', 'ID', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@EM_NORMANDIE_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@EM_NORMANDIE_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE1', 'Block 14, 3rd floor, Dubai Knowledge Park, UAE,', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@EM_NORMANDIE_STAFF_ID_CARD and keyValue='TRANS_ADDRESS_LINE2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@EM_NORMANDIE_STAFF_ID_CARD, 'TRANS_ADDRESS_LINE2', 'PO.Box: 500693', '1', NOW());
END IF;

END $$
CALL V20240903170349__Insert_EM_NORMANDIE_STAFF_ID_CARD() $$
DROP PROCEDURE IF EXISTS V20240903170349__Insert_EM_NORMANDIE_STAFF_ID_CARD $$
DELIMITER ;